"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizableButtonStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1fvu7sv-end",
  styles: "align-items:flex-end;label:end;"
} : {
  name: "1fvu7sv-end",
  styles: "align-items:flex-end;label:end;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "h0ntv8-start",
  styles: "align-items:flex-start;label:start;"
} : {
  name: "h0ntv8-start",
  styles: "align-items:flex-start;label:start;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "8391db-center",
  styles: "align-items:center;label:center;"
} : {
  name: "8391db-center",
  styles: "align-items:center;label:center;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiResizableButtonStyles = function euiResizableButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var buttonSize = euiTheme.size.base;
  var grabHandleWidth = euiTheme.size.m;
  var grabHandleHeight = euiTheme.border.width.thin;
  var transitionSpeed = euiTheme.animation.fast;
  var transition = "".concat(transitionSpeed, " ease");
  return {
    // Mimics the "grab" icon with CSS psuedo-elements.
    // 1. The "grab" icon transforms into a thicker straight line on :hover and :focus
    // 2. Start/end aligned handles should have a slight margin offset that disappears on hover/focus
    // 3. CSS hack to smooth out/anti-alias the 1px wide handles at various zoom levels
    euiResizableButton: /*#__PURE__*/(0, _react.css)("z-index:1;flex-shrink:0;display:flex;justify-content:center;gap:", (0, _global_styling.mathWithUnits)(grabHandleHeight, function (x) {
      return x * 2;
    }), ";&:disabled{display:none;}&:hover,&:focus{gap:0;justify-content:center;}", _global_styling.euiCanAnimate, "{transition:gap ", transition, ",justify-content ", transition, ";}&::before,&::after{content:'';display:block;background-color:", euiTheme.colors.darkestShade, ";transform:translateZ(0);", _global_styling.euiCanAnimate, "{transition:width ", transition, ",height ", transition, ",margin ", transition, ",background-color ", transition, ";}}&:hover{&::before,&::after{background-color:", euiTheme.colors.mediumShade, ";", _global_styling.euiCanAnimate, "{transition-delay:", transitionSpeed, ";}}}&:focus,&:active{background-color:", (0, _services.transparentize)(euiTheme.colors.primary, 0.1), ";&::before,&::after{background-color:", euiTheme.colors.primary, ";", _global_styling.euiCanAnimate, "{transition:width ", transition, ",height ", transition, ";transition-delay:", (0, _global_styling.mathWithUnits)(transitionSpeed, function (x) {
      return x / 2;
    }), ";}}};label:euiResizableButton;"),
    horizontal: /*#__PURE__*/(0, _react.css)("cursor:col-resize;", (0, _global_styling.logicalCSS)('height', '100%'), " ", (0, _global_styling.logicalCSS)('width', buttonSize), " margin-inline:", (0, _global_styling.mathWithUnits)(buttonSize, function (x) {
      return x / -2;
    }), ";&::before,&::after{", (0, _global_styling.logicalCSS)('width', grabHandleHeight), " ", (0, _global_styling.logicalCSS)('height', grabHandleWidth), " margin-block:", euiTheme.size.base, ";}&:hover,&:focus,&:active{&::before,&::after{", (0, _global_styling.logicalCSS)('height', '100%'), " margin-block:0;transform:none;}};label:horizontal;"),
    vertical: /*#__PURE__*/(0, _react.css)("flex-direction:column;cursor:row-resize;", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('height', buttonSize), " margin-block:", (0, _global_styling.mathWithUnits)(buttonSize, function (x) {
      return x / -2;
    }), ";&::before,&::after{", (0, _global_styling.logicalCSS)('height', grabHandleHeight), " ", (0, _global_styling.logicalCSS)('width', grabHandleWidth), " margin-inline:", euiTheme.size.base, ";}&:hover,&:focus,&:active{&::before,&::after{", (0, _global_styling.logicalCSS)('width', '100%'), " margin-inline:0;transform:none;}};label:vertical;"),
    alignIndicator: {
      center: _ref3,
      start: _ref2,
      end: _ref
    }
  };
};
exports.euiResizableButtonStyles = euiResizableButtonStyles;