"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPagination = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _pagination_button = require("./pagination_button");
var _i18n = require("../i18n");
var _text = require("../text");
var _pagination_button_arrow = require("./pagination_button_arrow");
var _services = require("../../services");
var _accessibility = require("../accessibility");
var _pagination = require("./pagination.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "pageCount", "activePage", "onPageClick", "compressed", "aria-controls", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var MAX_VISIBLE_PAGES = 5;
var NUMBER_SURROUNDING_PAGES = Math.floor(MAX_VISIBLE_PAGES * 0.5);
var EuiPagination = function EuiPagination(_ref) {
  var className = _ref.className,
    _ref$pageCount = _ref.pageCount,
    pageCount = _ref$pageCount === void 0 ? 1 : _ref$pageCount,
    _ref$activePage = _ref.activePage,
    activePage = _ref$activePage === void 0 ? 0 : _ref$activePage,
    _ref$onPageClick = _ref.onPageClick,
    onPageClick = _ref$onPageClick === void 0 ? function () {} : _ref$onPageClick,
    _compressed = _ref.compressed,
    ariaControls = _ref['aria-controls'],
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = (0, _services.useIsWithinBreakpoints)(responsive, !!responsive);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _pagination.euiPaginationStyles)(euiTheme);

  // Force to `compressed` version if specified or within the responsive breakpoints
  var compressed = _compressed || isResponsive;
  var safeClick = function safeClick(e, pageIndex) {
    e.preventDefault();
    if (ariaControls) {
      var controlledElement = document.getElementById(ariaControls);
      if (controlledElement) {
        controlledElement.focus();
      }
    }
    onPageClick(pageIndex);
  };
  var classes = (0, _classnames.default)('euiPagination', className);
  var firstButton = (pageCount < 1 || compressed) && (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "first",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, 0);
    },
    disabled: activePage === 0
  });
  var previousButton = (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "previous",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, activePage - 1);
    },
    disabled: activePage === 0
  });
  var nextButton = (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "next",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, activePage + 1);
    },
    disabled: activePage === -1 || activePage === pageCount - 1
  });
  var lastButton = (pageCount < 1 || compressed) && (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "last",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, pageCount ? pageCount - 1 : -1);
    },
    disabled: activePage === -1 || activePage === pageCount - 1
  });
  var centerPageCount;
  if (pageCount) {
    var sharedButtonProps = {
      activePage: activePage,
      ariaControls: ariaControls,
      safeClick: safeClick,
      pageCount: pageCount
    };
    if (compressed) {
      centerPageCount = (0, _react2.jsx)(_text.EuiText, {
        size: "s",
        css: styles.euiPagination__compressedText,
        className: "euiPagination__compressedText"
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiPagination.pageOfTotalCompressed",
        default: "{page} of {total}",
        values: {
          page: (0, _react2.jsx)("span", null, activePage + 1),
          total: (0, _react2.jsx)("span", null, pageCount)
        }
      }));
    } else {
      var pages = [];
      var firstPageInRange = Math.max(0, Math.min(activePage - NUMBER_SURROUNDING_PAGES, pageCount - MAX_VISIBLE_PAGES));
      var lastPageInRange = Math.min(pageCount, firstPageInRange + MAX_VISIBLE_PAGES);
      for (var i = firstPageInRange, index = 0; i < lastPageInRange; i++, index++) {
        pages.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
          pageIndex: i,
          key: i
        }, sharedButtonProps)));
      }
      var firstPageButtons = [];
      if (firstPageInRange > 0) {
        firstPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
          pageIndex: 0,
          key: 0
        }, sharedButtonProps)));
        if (firstPageInRange > 1 && firstPageInRange !== 2) {
          firstPageButtons.push((0, _react2.jsx)(_i18n.EuiI18n, {
            key: "startingEllipses",
            token: "euiPagination.firstRangeAriaLabel",
            default: "Skipping pages 2 to {lastPage}",
            values: {
              lastPage: firstPageInRange
            }
          }, function (firstRangeAriaLabel) {
            return (0, _react2.jsx)("li", {
              "aria-label": firstRangeAriaLabel,
              className: "euiPagination__item",
              css: styles.euiPagination__ellipsis
            }, "\u2026");
          }));
        } else if (firstPageInRange === 2) {
          firstPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
            pageIndex: 1,
            key: 1
          }, sharedButtonProps)));
        }
      }
      var lastPageButtons = [];
      if (lastPageInRange < pageCount) {
        if (lastPageInRange + 1 === pageCount - 1) {
          lastPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
            pageIndex: lastPageInRange,
            key: lastPageInRange
          }, sharedButtonProps)));
        } else if (lastPageInRange < pageCount - 1) {
          lastPageButtons.push((0, _react2.jsx)(_i18n.EuiI18n, {
            key: "endingEllipses",
            token: "euiPagination.lastRangeAriaLabel",
            default: "Skipping pages {firstPage} to {lastPage}",
            values: {
              firstPage: lastPageInRange + 1,
              lastPage: pageCount - 1
            }
          }, function (lastRangeAriaLabel) {
            return (0, _react2.jsx)("li", {
              "aria-label": lastRangeAriaLabel,
              className: "euiPagination__item",
              css: styles.euiPagination__ellipsis
            }, "\u2026");
          }));
        }
        lastPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
          pageIndex: pageCount - 1,
          key: pageCount - 1
        }, sharedButtonProps)));
      }
      var selectablePages = pages;
      var accessibleName = _objectSpread(_objectSpread({}, rest['aria-label'] && {
        'aria-label': rest['aria-label']
      }), rest['aria-labelledby'] && {
        'aria-labelledby': rest['aria-labelledby']
      });
      centerPageCount = (0, _react2.jsx)("ul", _extends({
        className: "euiPagination__list",
        css: styles.euiPagination__list
      }, accessibleName), firstPageButtons, selectablePages, lastPageButtons);
    }
  }

  // All the i18n strings used to build the whole SR-only text
  var lastLabel = (0, _i18n.useEuiI18n)('euiPagination.last', 'Last');
  var pageLabel = (0, _i18n.useEuiI18n)('euiPagination.page', 'Page');
  var ofLabel = (0, _i18n.useEuiI18n)('euiPagination.of', 'of');
  var collectionLabel = (0, _i18n.useEuiI18n)('euiPagination.collection', 'collection');
  var fromEndLabel = (0, _i18n.useEuiI18n)('euiPagination.fromEndLabel', 'from end');

  // Based on the `activePage` count, build the front of the SR-only text
  // i.e. `Page 1`, `Page 2 from end`, `Last Page`
  var accessiblePageString = function accessiblePageString() {
    if (activePage < -1) return "".concat(pageLabel, " ").concat(Math.abs(activePage), " ").concat(fromEndLabel);
    if (activePage === -1) return "".concat(lastLabel, " ").concat(pageLabel);
    return "".concat(pageLabel, " ").concat(activePage + 1);
  };

  // If `pageCount` is unknown call it `collection`
  var accessibleCollectionString = pageCount === 0 ? collectionLabel : pageCount.toString();

  // Create the whole string with total pageCount or `collection`
  var accessiblePageCount = "".concat(accessiblePageString(), " ").concat(ofLabel, " ").concat(accessibleCollectionString);
  return (0, _react2.jsx)("nav", _extends({
    css: styles.euiPagination,
    className: classes
  }, rest), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", {
    "aria-atomic": "true",
    "aria-relevant": "additions text",
    role: "status"
  }, accessiblePageCount)), firstButton, previousButton, centerPageCount, nextButton, lastButton);
};
exports.EuiPagination = EuiPagination;
EuiPagination.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * The total number of pages.
     * Pass `0` if total count is unknown.
     */
  pageCount: _propTypes.default.number,
  /**
     * The current page using a zero based index.
     * So if you set the activePage to 1, it will activate the second page.
     * Pass `-1` for forcing to last page.
     */
  activePage: _propTypes.default.number,
  /**
     * Click handler that passes back the internally calculated `activePage` index
     */
  onPageClick: _propTypes.default.func,
  /**
     * If true, will only show next/prev arrows and simplified number set.
     */
  compressed: _propTypes.default.bool,
  /**
     * If passed in, passes value through to each button to set aria-controls.
     */
  "aria-controls": _propTypes.default.string,
  /**
     * Automatically reduces to the `compressed` version on smaller screens.
     * Remove completely with `false` or provide your own list of responsive breakpoints.
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired])
};
var PaginationButtonWrapper = function PaginationButtonWrapper(_ref2) {
  var pageIndex = _ref2.pageIndex,
    _ref2$inList = _ref2.inList,
    inList = _ref2$inList === void 0 ? true : _ref2$inList,
    activePage = _ref2.activePage,
    pageCount = _ref2.pageCount,
    ariaControls = _ref2.ariaControls,
    safeClick = _ref2.safeClick,
    disabled = _ref2.disabled;
  var button = (0, _react2.jsx)(_pagination_button.EuiPaginationButton, {
    isActive: pageIndex === activePage,
    totalPages: pageCount,
    onClick: function onClick(e) {
      return safeClick(e, pageIndex);
    },
    pageIndex: pageIndex,
    "aria-controls": ariaControls,
    disabled: disabled
  });
  if (inList) {
    return (0, _react2.jsx)("li", {
      className: "euiPagination__item"
    }, button);
  }
  return button;
};