"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _control_bar = require("./control_bar");
var _panel = require("../panel");
var _text = require("../text");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var ControlBar = function ControlBar() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    contentIsVisible = _useState2[0],
    setVisibility = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isDisplaying = _useState4[0],
    setDisplay = _useState4[1];
  var toggleContent = function toggleContent() {
    setVisibility(!contentIsVisible);
  };
  var toggleDisplay = function toggleDisplay() {
    setDisplay(!isDisplaying);
    setVisibility(false);
  };
  var codeControls = [{
    controlType: 'icon',
    id: 'root_icon',
    iconType: 'submodule',
    'aria-label': 'Project Root'
  }, {
    controlType: 'breadcrumbs',
    id: 'current_file_path',
    breadcrumbs: [{
      text: 'src'
    }, {
      text: 'components'
    }]
  }, {
    controlType: 'spacer'
  }, {
    controlType: 'icon',
    id: 'status_icon',
    iconType: 'warning',
    color: 'warning',
    'aria-label': 'Repo Status'
  }, {
    controlType: 'divider'
  }, {
    controlType: 'icon',
    id: 'branch_icon',
    iconType: 'branch',
    'aria-label': 'Branch Icon'
  }, {
    controlType: 'text',
    id: 'branch_name',
    text: 'some_long_branch'
  }, {
    controlType: 'divider'
  }, {
    controlType: 'icon',
    id: 'github_icon',
    iconType: 'logoGithub',
    onClick: function onClick() {},
    title: 'Open in Github',
    'aria-label': 'Open in Github'
  }, {
    controlType: 'divider'
  }, {
    controlType: 'button',
    id: 'open_history_view',
    label: contentIsVisible ? 'Hide history' : 'Show history',
    color: 'primary',
    onClick: toggleContent
  }];
  var display;
  if (isDisplaying) {
    display = (0, _react2.jsx)(_control_bar.EuiControlBar, {
      controls: codeControls,
      showContent: contentIsVisible
    }, (0, _react2.jsx)("div", {
      style: {
        padding: '2rem',
        maxWidth: '60rem',
        margin: '0 auto'
      }
    }, (0, _react2.jsx)(_panel.EuiPanel, null, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("h1", null, "1984"), (0, _react2.jsx)("h3", null, "By: George Orwell"), (0, _react2.jsx)("p", null, "It was a bright cold day in April, and the clocks were striking thirteen. Winston Smith, his chin nuzzled into his breast in an effort to escape the vile wind, slipped quickly through the glass doors of Victory Mansions, though not quickly enough to prevent a swirl of gritty dust from entering along with him."), (0, _react2.jsx)("p", null, "The hallway smelt of boiled cabbage and old rag mats. At one end of it a coloured poster, too large for indoor display, had been tacked to the wall. It depicted simply an enormous face, more than a metre wide: the face of a man of about forty-five, with a heavy black moustache and ruggedly handsome features. Winston made for the stairs. It was no use trying the lift. Even at the best of times it was seldom working, and at present the electric current was cut off during daylight hours. It was part of the economy drive in preparation for Hate Week. The flat was seven flights up, and Winston, who was thirty-nine and had a varicose ulcer above his right ankle, went slowly, resting several times on the way. On each landing, opposite the lift-shaft, the poster with the enormous face gazed from the wall. It was one of those pictures which are so contrived that the eyes follow you about when you move. BIG BROTHER IS WATCHING YOU, the caption beneath it ran."), (0, _react2.jsx)("p", null, "Inside the flat a fruity voice was reading out a list of figures which had something to do with the production of pig-iron. The voice came from an oblong metal plaque like a dulled mirror which formed part of the surface of the right-hand wall. Winston turned a switch and the voice sank somewhat, though the words were still distinguishable. The instrument (the telescreen, it was called) could be dimmed, but there was no way of shutting it off completely. He moved over to the window: a smallish, frail figure, the meagreness of his body merely emphasized by the blue overalls which were the uniform of the party. His hair was very fair, his face naturally sanguine, his skin roughened by coarse soap and blunt razor blades and the cold of the winter that had just ended.")))));
  }
  return (0, _react2.jsx)("div", null, (0, _react2.jsx)(_button.EuiButton, {
    onClick: toggleDisplay
  }, "Toggle example"), display);
};
beforeEach(function () {
  cy.viewport(1024, 768);
  cy.mount((0, _react2.jsx)(ControlBar, null));
  cy.get('section[aria-label="Page level controls"]').should('not.exist');
});
describe('EuiControlBar', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when control bar is shown', function () {
      cy.get('button.euiButton').contains('Toggle example').realClick();
      cy.get('section[aria-label="Page level controls"]').should('exist');
      cy.checkAxe({
        context: 'section[aria-label="Page level controls"]'
      });
    });
    it('has zero violations when control bar is hidden', function () {
      cy.get('button.euiButton').contains('Toggle example').realClick();
      cy.get('section[aria-label="Page level controls"]').should('exist');
      cy.get('button.euiButton').contains('Toggle example').realClick();
      cy.get('section[aria-label="Page level controls"]').should('not.exist');
      cy.checkAxe();
    });
  });
});