"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiContextMenuPanelStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _title = require("../title/title.styles");
var _context_menu = require("./context_menu.styles");
var _templateObject, _templateObject2, _templateObject3, _templateObject4;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
var euiContextMenuPanelStyles = function euiContextMenuPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiContextMenuVariab = (0, _context_menu.euiContextMenuVariables)(euiThemeContext),
    panelWidth = _euiContextMenuVariab.panelWidth;
  var animations = {
    transitioning: /*#__PURE__*/(0, _react.css)("pointer-events:none;animation-fill-mode:forwards;animation-duration:", euiTheme.animation.normal, ";animation-timing-function:", euiTheme.animation.resistance, ";", _global_styling.euiCantAnimate, "{animation-duration:0s;};label:transitioning;"),
    inLeft: (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n      0% { transform: translateX(", "); }\n      100% { transform: translateX(0); }\n    "])), panelWidth),
    outLeft: (0, _react.keyframes)(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n      0% { transform: translateX(0); }\n      100% { transform: translateX(-", "); }\n    "])), panelWidth),
    inRight: (0, _react.keyframes)(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n      0% { transform: translateX(-", "); }\n      100% { transform: translateX(0); }\n    "])), panelWidth),
    outRight: (0, _react.keyframes)(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["\n      0% { transform: translateX(0); }\n      100% { transform: translateX(", "); }\n    "])), panelWidth)
  };
  return {
    euiContextMenuPanel: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), " visibility:visible;outline-offset:-", euiTheme.focus.width, ";&:focus{outline:none;};label:euiContextMenuPanel;"),
    // Panel animations
    next: {
      in: /*#__PURE__*/(0, _react.css)(animations.transitioning, " animation-name:", animations.inLeft, ";;label:in;"),
      out: /*#__PURE__*/(0, _react.css)(animations.transitioning, " animation-name:", animations.outLeft, ";;label:out;")
    },
    previous: {
      in: /*#__PURE__*/(0, _react.css)(animations.transitioning, " animation-name:", animations.inRight, ";;label:in;"),
      out: /*#__PURE__*/(0, _react.css)(animations.transitioning, " animation-name:", animations.outRight, ";;label:out;")
    },
    // Children
    euiContextMenuPanel__title: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxs'), " ", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), " &:enabled:focus{background-color:unset;};label:euiContextMenuPanel__title;")
  };
};
exports.euiContextMenuPanelStyles = euiContextMenuPanelStyles;