"use strict";

var _react = _interopRequireDefault(require("react"));
var _context_menu_item = require("./context_menu_item");
var _context_menu_panel = require("./context_menu_panel");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var items = [(0, _react2.jsx)(_context_menu_item.EuiContextMenuItem, {
  key: "A",
  "data-test-subj": "itemA",
  href: "#"
}, "Option A"), (0, _react2.jsx)(_context_menu_item.EuiContextMenuItem, {
  key: "B",
  "data-test-subj": "itemB",
  onClick: function onClick() {}
}, "Option B"), (0, _react2.jsx)(_context_menu_item.EuiContextMenuItem, {
  key: "C",
  "data-test-subj": "itemC"
}, "Option C")];
describe('EuiContextMenuPanel', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations', function () {
      var showNextPanelHandler = cy.stub();
      cy.mount((0, _react2.jsx)(_context_menu_panel.EuiContextMenuPanel, {
        items: items,
        showNextPanel: showNextPanelHandler
      }));
      cy.checkAxe();
    });
  });
});