"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiContextMenuVariables = exports.euiContextMenuStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiContextMenuVariables = function euiContextMenuVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    panelWidth: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 16;
    })
  };
};
exports.euiContextMenuVariables = euiContextMenuVariables;
var euiContextMenuStyles = function euiContextMenuStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiContextMenuVariab = euiContextMenuVariables(euiThemeContext),
    panelWidth = _euiContextMenuVariab.panelWidth;
  return {
    euiContextMenu: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', panelWidth), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " position:relative;overflow:hidden;border-radius:", euiTheme.border.radius.medium, ";", _global_styling.euiCanAnimate, "{transition:height ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";};label:euiContextMenu;")
  };
};
exports.euiContextMenuStyles = euiContextMenuStyles;