"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformForCaseSensitivity = exports.getSelectedOptionForSearchValue = exports.getMatchingOptions = exports.flattenOptionGroups = void 0;
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var transformForCaseSensitivity = function transformForCaseSensitivity(string, isCaseSensitive) {
  return isCaseSensitive ? string : string.toLowerCase();
};
exports.transformForCaseSensitivity = transformForCaseSensitivity;
var flattenOptionGroups = function flattenOptionGroups(optionsOrGroups) {
  return optionsOrGroups.reduce(function (options, optionOrGroup) {
    if (optionOrGroup.options) {
      options = options.concat(optionOrGroup.options);
    } else {
      options.push(optionOrGroup);
    }
    return options;
  }, []);
};
exports.flattenOptionGroups = flattenOptionGroups;
var getSelectedOptionForSearchValue = function getSelectedOptionForSearchValue(_ref) {
  var isCaseSensitive = _ref.isCaseSensitive,
    searchValue = _ref.searchValue,
    selectedOptions = _ref.selectedOptions,
    optionKey = _ref.optionKey;
  var normalizedSearchValue = transformForCaseSensitivity(searchValue, isCaseSensitive);
  return selectedOptions.find(function (option) {
    var normalizedOption = transformForCaseSensitivity(option.label, isCaseSensitive);
    return normalizedOption === normalizedSearchValue && (!optionKey || option.key === optionKey);
  });
};
exports.getSelectedOptionForSearchValue = getSelectedOptionForSearchValue;
var collectMatchingOption = function collectMatchingOption(_ref2) {
  var accumulator = _ref2.accumulator,
    option = _ref2.option,
    selectedOptions = _ref2.selectedOptions,
    normalizedSearchValue = _ref2.normalizedSearchValue,
    isCaseSensitive = _ref2.isCaseSensitive,
    isPreFiltered = _ref2.isPreFiltered,
    showPrevSelected = _ref2.showPrevSelected;
  // Only show options which haven't yet been selected unless requested.
  var selectedOption = getSelectedOptionForSearchValue({
    isCaseSensitive: isCaseSensitive,
    searchValue: option.label,
    selectedOptions: selectedOptions,
    optionKey: option.key
  });
  if (selectedOption && !showPrevSelected) {
    return false;
  }

  // If the options have already been pre-filtered then we can skip filtering against the search value.
  if (isPreFiltered) {
    accumulator.push(option);
    return;
  }
  if (!normalizedSearchValue) {
    accumulator.push(option);
    return;
  }
  var normalizedOption = transformForCaseSensitivity(option.label.trim(), isCaseSensitive);
  if (normalizedOption.includes(normalizedSearchValue)) {
    accumulator.push(option);
  }
};
var getMatchingOptions = function getMatchingOptions(_ref3) {
  var options = _ref3.options,
    selectedOptions = _ref3.selectedOptions,
    searchValue = _ref3.searchValue,
    _ref3$isCaseSensitive = _ref3.isCaseSensitive,
    isCaseSensitive = _ref3$isCaseSensitive === void 0 ? false : _ref3$isCaseSensitive,
    _ref3$isPreFiltered = _ref3.isPreFiltered,
    isPreFiltered = _ref3$isPreFiltered === void 0 ? false : _ref3$isPreFiltered,
    _ref3$showPrevSelecte = _ref3.showPrevSelected,
    showPrevSelected = _ref3$showPrevSelecte === void 0 ? false : _ref3$showPrevSelecte,
    _ref3$sortMatchesBy = _ref3.sortMatchesBy,
    sortMatchesBy = _ref3$sortMatchesBy === void 0 ? 'none' : _ref3$sortMatchesBy;
  var normalizedSearchValue = transformForCaseSensitivity(searchValue.trim(), isCaseSensitive);
  var matchingOptions = [];
  options.forEach(function (option) {
    if (option.options) {
      var matchingOptionsForGroup = [];
      option.options.forEach(function (groupOption) {
        collectMatchingOption({
          accumulator: matchingOptionsForGroup,
          option: groupOption,
          selectedOptions: selectedOptions,
          normalizedSearchValue: normalizedSearchValue,
          isCaseSensitive: isCaseSensitive,
          isPreFiltered: isPreFiltered,
          showPrevSelected: showPrevSelected
        });
      });
      if (matchingOptionsForGroup.length > 0) {
        // Add option for group label
        matchingOptions.push({
          key: option.key,
          label: option.label,
          isGroupLabelOption: true
        });
        // Add matching options for group
        // use concat over spreading to support large arrays - https://mathiasbynens.be/demo/javascript-argument-count
        matchingOptions = matchingOptions.concat(matchingOptionsForGroup);
      }
    } else {
      collectMatchingOption({
        accumulator: matchingOptions,
        option: option,
        selectedOptions: selectedOptions,
        normalizedSearchValue: normalizedSearchValue,
        isCaseSensitive: isCaseSensitive,
        isPreFiltered: isPreFiltered,
        showPrevSelected: showPrevSelected
      });
    }
  });
  if (sortMatchesBy === 'startsWith') {
    var refObj = {
      startWith: [],
      others: []
    };
    matchingOptions.forEach(function (object) {
      var normalizedLabel = transformForCaseSensitivity(object.label, isCaseSensitive);
      if (normalizedLabel.startsWith(normalizedSearchValue)) {
        refObj.startWith.push(object);
      } else {
        refObj.others.push(object);
      }
    });
    return [].concat(_toConsumableArray(refObj.startWith), _toConsumableArray(refObj.others));
  }
  return matchingOptions;
};
exports.getMatchingOptions = getMatchingOptions;