"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxPill = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _badge = require("../../badge");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["asPlainText", "children", "className", "color", "onClick", "onClickAriaLabel", "onClose", "option"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var EuiComboBoxPill = /*#__PURE__*/function (_Component) {
  _inherits(EuiComboBoxPill, _Component);
  var _super = _createSuper(EuiComboBoxPill);
  function EuiComboBoxPill() {
    var _this;
    _classCallCheck(this, EuiComboBoxPill);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "onCloseButtonClick", function () {
      var _this$props = _this.props,
        onClose = _this$props.onClose,
        option = _this$props.option;
      if (onClose) {
        onClose(option);
      }
    });
    return _this;
  }
  _createClass(EuiComboBoxPill, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        asPlainText = _this$props2.asPlainText,
        children = _this$props2.children,
        className = _this$props2.className,
        color = _this$props2.color,
        onClick = _this$props2.onClick,
        onClickAriaLabel = _this$props2.onClickAriaLabel,
        onClose = _this$props2.onClose,
        option = _this$props2.option,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var classes = (0, _classnames.default)('euiComboBoxPill', {
        'euiComboBoxPill--plainText': asPlainText
      }, className);
      var onClickProps = onClick && onClickAriaLabel ? {
        onClick: onClick,
        onClickAriaLabel: onClickAriaLabel
      } : {};
      var content = (0, _react2.jsx)(_react.default.Fragment, null, option.prepend && (0, _react2.jsx)("span", {
        className: "euiComboBoxPill__prepend"
      }, option.prepend), (0, _react2.jsx)("span", {
        className: "eui-textTruncate"
      }, children), option.append && (0, _react2.jsx)("span", {
        className: "euiComboBoxPill__append"
      }, option.append));
      if (onClose) {
        return (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiComboBoxPill.removeSelection",
          default: "Remove {children} from selection in this group",
          values: {
            children: children
          }
        }, function (removeSelection) {
          return (0, _react2.jsx)(_badge.EuiBadge, _extends({
            className: classes,
            color: color,
            "data-test-subj": "euiComboBoxPill",
            iconOnClick: _this2.onCloseButtonClick,
            iconOnClickAriaLabel: removeSelection,
            iconSide: "right",
            iconType: "cross",
            title: children
          }, onClickProps, rest), content);
        });
      }
      if (asPlainText) {
        return (0, _react2.jsx)("span", _extends({
          className: classes,
          "data-test-subj": "euiComboBoxPill"
        }, rest), content);
      }
      return (0, _react2.jsx)(_badge.EuiBadge, _extends({
        className: classes,
        color: color,
        "data-test-subj": "euiComboBoxPill",
        title: children
      }, rest, onClickProps), content);
    }
  }]);
  return EuiComboBoxPill;
}(_react.Component);
exports.EuiComboBoxPill = EuiComboBoxPill;
_defineProperty(EuiComboBoxPill, "defaultProps", {
  color: 'hollow'
});
EuiComboBoxPill.propTypes = {
  asPlainText: _propTypes.default.bool,
  children: _propTypes.default.string,
  className: _propTypes.default.string,
  color: _propTypes.default.string,
  onClick: _propTypes.default.func,
  onClickAriaLabel: _propTypes.default.any,
  onClose: _propTypes.default.func,
  option: _propTypes.default.shape({
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    key: _propTypes.default.string,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      key: _propTypes.default.string,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any,
      prepend: _propTypes.default.node,
      append: _propTypes.default.node,
      truncationProps: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any,
    prepend: _propTypes.default.node,
    append: _propTypes.default.node,
    truncationProps: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};