"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavBeta = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout = require("../flyout");
var _i18n = require("../i18n");
var _header = require("../header/header.styles");
var _context = require("./context");
var _collapsible_nav_button = require("./collapsible_nav_button");
var _collapsible_nav_beta = require("./collapsible_nav_beta.styles");
var _collapsible_nav_body_footer = require("./collapsible_nav_body_footer");
var _collapsible_nav_group = require("./collapsible_nav_group");
var _collapsible_nav_item = require("./collapsible_nav_item");
var _react2 = require("@emotion/react");
var _excluded = ["id", "children", "className", "initialIsCollapsed", "onCollapseToggle", "width", "side", "focusTrapProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var _EuiCollapsibleNavBeta = function _EuiCollapsibleNavBeta(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$initialIsCollaps = _ref.initialIsCollapsed,
    initialIsCollapsed = _ref$initialIsCollaps === void 0 ? false : _ref$initialIsCollaps,
    onCollapseToggle = _ref.onCollapseToggle,
    _ref$width = _ref.width,
    _width = _ref$width === void 0 ? 248 : _ref$width,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _focusTrapProps = _ref.focusTrapProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useEuiThemeCSSVariab = (0, _services.useEuiThemeCSSVariables)(),
    setGlobalCSSVariables = _useEuiThemeCSSVariab.setGlobalCSSVariables;
  var euiTheme = (0, _services.useEuiTheme)();
  var headerHeight = (0, _header.euiHeaderVariables)(euiTheme).height;

  /**
   * Collapsed state
   */
  var _useState = (0, _react.useState)(initialIsCollapsed),
    _useState2 = _slicedToArray(_useState, 2),
    isCollapsed = _useState2[0],
    setIsCollapsed = _useState2[1];
  var toggleCollapsed = (0, _react.useCallback)(function () {
    return setIsCollapsed(function (isCollapsed) {
      onCollapseToggle === null || onCollapseToggle === void 0 ? void 0 : onCollapseToggle(!isCollapsed);
      return !isCollapsed;
    });
  }, [onCollapseToggle]);
  var onClose = (0, _react.useCallback)(function () {
    return setIsCollapsed(true);
  }, []);

  /**
   * Responsive behavior
   * By default on large enough screens, the nav is always a push flyout,
   * but on smaller/mobile screens, the nav overlays the page instead
   */
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isOverlay = _useState4[0],
    setIsOverlay = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = _slicedToArray(_useState5, 2),
    isOverlayFullWidth = _useState6[0],
    setIsOverlayFullWidth = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isOverlayOpen = _useState8[0],
    setIsOverlayOpen = _useState8[1];
  var toggleOverlayFlyout = (0, _react.useCallback)(function () {
    setIsOverlayOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var flyoutType = isOverlay ? 'overlay' : 'push';
  var isPush = !isOverlay;

  // Set up a window resize listener that determines breakpoint behavior
  (0, _react.useEffect)(function () {
    var getBreakpoints = function getBreakpoints() {
      setIsOverlay(window.innerWidth < _width * 3);
      setIsOverlayFullWidth(window.innerWidth < _width * 1.5);
    };
    getBreakpoints();
    var onWindowResize = (0, _services.throttle)(getBreakpoints, 50);
    window.addEventListener('resize', onWindowResize);
    return function () {
      return window.removeEventListener('resize', onWindowResize);
    };
  }, [_width]);
  var width = (0, _react.useMemo)(function () {
    if (isOverlayFullWidth) return '100%';
    if (isPush && isCollapsed) return headerHeight;
    return "".concat(_width, "px");
  }, [_width, isOverlayFullWidth, isPush, isCollapsed, headerHeight]);

  // Other UI elements may need to account for the nav width -
  // set a global CSS variable that they can use
  (0, _react.useEffect)(function () {
    setGlobalCSSVariables({
      '--euiCollapsibleNavOffset': isOverlay ? '0' : width
    });
  }, [width, isOverlay, setGlobalCSSVariables]);

  /**
   * Prop setup
   */
  var flyoutID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var defaultAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavBeta.ariaLabel', 'Site menu');
  var buttonRef = (0, _react.useRef)(null);
  var focusTrapProps = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
      shards: [buttonRef].concat(_toConsumableArray((_focusTrapProps === null || _focusTrapProps === void 0 ? void 0 : _focusTrapProps.shards) || []))
    });
  }, [_focusTrapProps]);
  var classes = (0, _classnames.default)('euiCollapsibleNav', 'euiCollapsibleNavBeta', className);
  var styles = (0, _collapsible_nav_beta.euiCollapsibleNavBetaStyles)(euiTheme);
  var cssStyles = [styles.euiCollapsibleNavBeta, styles[side], isPush && styles.isPush, isPush && isCollapsed && styles.isPushCollapsed, isOverlayFullWidth && styles.isOverlayFullWidth];
  var flyout = (0, _react2.jsx)(_flyout.EuiFlyout, _extends({
    "aria-label": defaultAriaLabel
  }, rest, {
    // EuiCollapsibleNav is significantly less permissive than EuiFlyout
    id: flyoutID,
    css: cssStyles,
    className: classes,
    size: width,
    side: side,
    focusTrapProps: focusTrapProps,
    as: "nav",
    type: flyoutType,
    paddingSize: "none",
    pushMinBreakpoint: "xs",
    onClose: onClose,
    hideCloseButton: true
  }), children);
  var hideFlyout = isOverlay && !isOverlayOpen;
  return (0, _react2.jsx)(_context.EuiCollapsibleNavContext.Provider, {
    value: {
      isPush: isPush,
      isCollapsed: isCollapsed,
      isOverlayOpen: isOverlayOpen,
      side: side
    }
  }, (0, _react2.jsx)(_collapsible_nav_button.EuiCollapsibleNavButton, {
    ref: buttonRef,
    onClick: isPush ? toggleCollapsed : toggleOverlayFlyout,
    "aria-controls": flyoutID
  }), !hideFlyout && flyout);
};

/**
 * Combined export with subcomponents
 */
_EuiCollapsibleNavBeta.propTypes = {
  className: _propTypes.default.string,
  /**
       * Overlay flyouts are considered dialogs, and dialogs must have a label.
       * By default, a label of `Site menu` will be applied.
       *
       * If your usage of this component is not actually for site-wide navigation,
       * please set your own `aria-label` or `aria-labelledby`.
       *
       * @default 'Site menu'
       */
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * ReactNode(s) to render as navigation flyout content, typically `EuiCollapsibleNavBeta.Item`s.
       * You will likely want to use `EuiCollapsibleNavBeta.Body` and `EuiCollapsibleNavBeta.Footer`
       * for organization.
       */
  children: _propTypes.default.node,
  /**
       * Whether the navigation flyout should default to initially collapsed or expanded
       */
  initialIsCollapsed: _propTypes.default.bool,
  /**
       * Optional callback that fires when the user toggles the nav between
       * collapsed and uncollapsed states
       */
  onCollapseToggle: _propTypes.default.func,
  /**
       * Defaults to 248px wide. The navigation width determines behavior at
       * various responsive breakpoints.
       *
       * At larger screen sizes (at least 3x the width of the nav), the nav will
       * be able to be toggled between a docked full width nav and a collapsed
       * side bar that only shows the icon of each item.
       *
       * At under 3 times the width of the nav, the behavior will lose the collapsed
       * side bar behavior, and switch from a docked flyout to an overlay flyout only.
       *
       * If the page is under 1.5 times the width of the nav, the overlay will
       * take up the full width of the page.
       */
  width: _propTypes.default.number
};
var EuiCollapsibleNavBeta = Object.assign(_EuiCollapsibleNavBeta, {
  Body: _collapsible_nav_body_footer.EuiCollapsibleNavBody,
  Footer: _collapsible_nav_body_footer.EuiCollapsibleNavFooter,
  Group: _collapsible_nav_group.EuiCollapsibleNavGroup,
  Item: _collapsible_nav_item.EuiCollapsibleNavItem
});
exports.EuiCollapsibleNavBeta = EuiCollapsibleNavBeta;