"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCodeBlockStyles = exports.euiCodeBlockPreStyles = exports.euiCodeBlockCodeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _code_syntax = require("./code_syntax.styles");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */ /*
                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                               */
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "i92zwx-isFullScreen",
  styles: "position:fixed;inset:0;label:isFullScreen;"
} : {
  name: "i92zwx-isFullScreen",
  styles: "position:fixed;inset:0;label:isFullScreen;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "gfiv3z-transparentBackground",
  styles: "background:transparent;label:transparentBackground;"
} : {
  name: "gfiv3z-transparentBackground",
  styles: "background:transparent;label:transparentBackground;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeBlockStyles = function euiCodeBlockStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiCodeSyntax = (0, _code_syntax.euiCodeSyntaxColors)(euiThemeContext);
  return {
    euiCodeBlock: /*#__PURE__*/(0, _react.css)("max-inline-size:100%;display:block;position:relative;background:", euiCodeSyntax.backgroundColor, ";", (0, _code_syntax.euiCodeSyntaxTokens)(euiThemeContext), ";;label:euiCodeBlock;"),
    // Font size
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'm'), ";;label:l;"),
    // Variants
    transparentBackground: _ref5,
    isFullScreen: _ref4,
    // Account for control heights
    hasControls: generatePaddingCss(euiThemeContext, function (paddingSize) {
      return /*#__PURE__*/(0, _react.css)("min-block-size:", (0, _global_styling.mathWithUnits)([euiTheme.size.l, paddingSize], function (iconSize, paddingSize) {
        return iconSize + paddingSize * 2;
      }), ";;label:hasControls;");
    }),
    hasBothControls: generatePaddingCss(euiThemeContext, function (paddingSize) {
      return /*#__PURE__*/(0, _react.css)("min-block-size:", (0, _global_styling.mathWithUnits)([euiTheme.size.l, euiTheme.size.xs, paddingSize], function (iconSize, gap, paddingSize) {
        return iconSize * 2 + gap + paddingSize * 2;
      }), ";;label:hasBothControls;");
    })
  };
};
exports.euiCodeBlockStyles = euiCodeBlockStyles;
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "eav5br-preWrap",
  styles: "white-space:pre-wrap;label:preWrap;"
} : {
  name: "eav5br-preWrap",
  styles: "white-space:pre-wrap;label:preWrap;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "4dmmkq-pre",
  styles: "white-space:pre;label:pre;"
} : {
  name: "4dmmkq-pre",
  styles: "white-space:pre;label:pre;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeBlockPreStyles = function euiCodeBlockPreStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCodeBlock__pre: /*#__PURE__*/(0, _react.css)("block-size:100%;overflow:auto;display:block;", (0, _global_styling.euiScrollBarStyles)(euiThemeContext), ";;label:euiCodeBlock__pre;"),
    padding: _objectSpread({}, generatePaddingCss(euiThemeContext, function (paddingSize) {
      return /*#__PURE__*/(0, _react.css)("padding:", paddingSize, ";;label:padding;");
    })),
    whiteSpace: {
      pre: {
        pre: _ref3,
        controlsOffset: generatePaddingCss(euiThemeContext, function (paddingSize) {
          return /*#__PURE__*/(0, _react.css)("margin-inline-end:", (0, _global_styling.mathWithUnits)([paddingSize, euiTheme.size.l, euiTheme.size.xs], function (paddingSize, iconSize, gap) {
            return paddingSize + gap + iconSize;
          }), ";;label:controlsOffset;");
        })
      },
      preWrap: {
        preWrap: _ref2,
        controlsOffset: generatePaddingCss(euiThemeContext, function (paddingSize) {
          return /*#__PURE__*/(0, _react.css)("padding-inline-end:", (0, _global_styling.mathWithUnits)([paddingSize, euiTheme.size.l, euiTheme.size.xs], function (paddingSize, iconSize, gap) {
            return paddingSize + gap + iconSize;
          }), ";;label:controlsOffset;");
        })
      }
    }
  };
};
exports.euiCodeBlockPreStyles = euiCodeBlockPreStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "9y8iu3-isVirtualized",
  styles: "position:relative;label:isVirtualized;"
} : {
  name: "9y8iu3-isVirtualized",
  styles: "position:relative;label:isVirtualized;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeBlockCodeStyles = function euiCodeBlockCodeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiCodeSyntax = (0, _code_syntax.euiCodeSyntaxColors)(euiThemeContext);
  return {
    euiCodeBlock__code: /*#__PURE__*/(0, _react.css)("font-family:", euiTheme.font.familyCode, ";font-size:inherit;color:", euiCodeSyntax.color, ";display:block;;label:euiCodeBlock__code;"),
    isVirtualized: _ref
  };
};

/**
 * Helper for generating keys for each code block padding size
 */
exports.euiCodeBlockCodeStyles = euiCodeBlockCodeStyles;
var generatePaddingCss = function generatePaddingCss(euiThemeContext, callback) {
  var cssKeys = {
    none: /*#__PURE__*/(0, _react.css)(";label:none;"),
    s: /*#__PURE__*/(0, _react.css)(";label:s;"),
    m: /*#__PURE__*/(0, _react.css)(";label:m;"),
    l: /*#__PURE__*/(0, _react.css)(";label:l;"),
    xl: /*#__PURE__*/(0, _react.css)(";label:xl;")
  }; // xl padding used by fullscreen mode

  ['none', 's', 'm', 'l', 'xl'].forEach(function (size) {
    var paddingSize = (0, _global_styling.euiPaddingSize)(euiThemeContext, size) || 0;
    cssKeys[size] = callback(paddingSize);
  });
  return cssKeys;
};