"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCardSelect = void 0;
exports.euiCardSelectableColor = euiCardSelectableColor;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../i18n");
var _button = require("../../button/button");
var _card_select = require("./card_select.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isSelected", "isDisabled", "disabled", "color", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiCardSelect = function EuiCardSelect(_ref) {
  var _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    isDisabled = _ref.isDisabled,
    disabled = _ref.disabled,
    color = _ref.color,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _card_select.euiCardSelectStyles)();
  var baseCSS = [styles.euiCardSelect];
  var child = euiCardSelectableText(isSelected, isDisabled || disabled, children);
  return (0, _react2.jsx)(_button.EuiButton, _extends({
    css: baseCSS,
    color: euiCardSelectableColor(color, isSelected),
    size: "m",
    isDisabled: isDisabled || disabled,
    iconType: isSelected ? 'check' : undefined,
    role: "switch",
    "aria-checked": isSelected,
    fullWidth: true
  }, rest), child);
};
exports.EuiCardSelect = EuiCardSelect;
EuiCardSelect.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     */
  color: _propTypes.default.any,
  /**
     * Use size `s` in confined spaces
     */
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * `disabled` is also allowed
     */
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any
};
function euiCardSelectableText(isSelected, isDisabled, children) {
  if (children) {
    return children;
  }
  var text;
  if (isSelected) {
    text = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCardSelect.selected",
      default: "Selected"
    });
  } else if (isDisabled) {
    text = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCardSelect.unavailable",
      default: "Unavailable"
    });
  } else {
    text = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCardSelect.select",
      default: "Select"
    });
  }
  return text;
}
function euiCardSelectableColor(color, isSelected) {
  var calculatedColor;
  if (color) {
    calculatedColor = color;
  } else if (isSelected) {
    calculatedColor = 'success';
  } else {
    calculatedColor = 'text';
  }
  return calculatedColor;
}