"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonIconStyles = exports._emptyHoverStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _button = require("../../../themes/amsterdam/global_styling/mixins/button");
var _button_display = require("../button_display/_button_display.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;"
} : {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiButtonIconStyles = function euiButtonIconStyles(euiThemeContext) {
  var sizes = (0, _button.euiButtonSizeMap)(euiThemeContext);
  return {
    euiButtonIcon: /*#__PURE__*/(0, _react.css)((0, _button_display.euiButtonBaseCSS)(), "display:inline-flex;align-items:center;justify-content:space-around;&>svg{pointer-events:none;};label:euiButtonIcon;"),
    isDisabled: _ref,
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(sizes.xs.height), " border-radius:", sizes.xs.radius, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(sizes.s.height), " border-radius:", sizes.s.radius, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(sizes.m.height), " border-radius:", sizes.m.radius, ";;label:m;")
  };
};
exports.euiButtonIconStyles = euiButtonIconStyles;
var _emptyHoverStyles = function _emptyHoverStyles(euiThemeContext, color) {
  return /*#__PURE__*/(0, _react.css)("&:hover{background-color:", (0, _button.euiButtonEmptyColor)(euiThemeContext, color).backgroundColor, ";}");
};
exports._emptyHoverStyles = _emptyHoverStyles;