"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonGroupButtonStyles = exports._uncompressedButtonFocus = exports._compressedButtonFocusColor = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _button = require("../../../themes/amsterdam/global_styling/mixins/button");
var _accessibility = require("../../accessibility");
var _form = require("../../form/form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiButtonGroupButtonStyles = function euiButtonGroupButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight,
    controlCompressedBorderRadius = _euiFormVariables.controlCompressedBorderRadius;
  var compressedButtonHeight = (0, _global_styling.mathWithUnits)([controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
    return x - y * 2;
  });
  var uncompressedBorderRadii = function uncompressedBorderRadii(radiusSize) {
    return "\n    border-radius: 0;\n\n    &:first-child {\n      ".concat((0, _global_styling.logicalShorthandCSS)('border-radius', "".concat(radiusSize, " 0 0 ").concat(radiusSize)), "\n    }\n\n    &:last-child {\n      ").concat((0, _global_styling.logicalShorthandCSS)('border-radius', "0 ".concat(radiusSize, " ").concat(radiusSize, " 0")), "\n    }\n  ");
  };
  return {
    // Base
    euiButtonGroupButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', 0), " flex-shrink:1;flex-grow:0;", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.normal, " ease-in-out,color ", euiTheme.animation.normal, " ease-in-out;};label:euiButtonGroupButton;"),
    iconOnly: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.s, ";;label:iconOnly;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)(uncompressedBorderRadii(euiTheme.border.radius.small), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)(uncompressedBorderRadii(euiTheme.border.radius.medium), ";;label:m;"),
    uncompressed: /*#__PURE__*/(0, _react.css)("&:is(.euiButtonGroupButton-isSelected){font-weight:", euiTheme.font.weight.bold, ";}&:not(.euiButtonGroupButton-isSelected)+.euiButtonGroupButton:not(.euiButtonGroupButton-isSelected){box-shadow:-", euiTheme.border.width.thin, " 0 0 0 ", (0, _services.transparentize)(euiTheme.colors.fullShade, 0.1), ";}&:is(.euiButtonGroupButton-isSelected)+.euiButtonGroupButton-isSelected{box-shadow:-", euiTheme.border.width.thin, " 0 0 0 ", (0, _services.transparentize)(euiTheme.colors.emptyShade, 0.2), ";};label:uncompressed;"),
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', compressedButtonHeight), " line-height:", compressedButtonHeight, ";padding:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x * 2;
    }), ";background-clip:content-box;border-radius:", (0, _global_styling.mathWithUnits)([controlCompressedBorderRadius, euiTheme.border.width.thin], function (x, y) {
      return x + y;
    }), ";font-weight:", euiTheme.font.weight.regular, ";&:is(.euiButtonGroupButton-isSelected){font-weight:", euiTheme.font.weight.semiBold, ";};label:compressed;"),
    // States
    disabledAndSelected: /*#__PURE__*/(0, _react.css)("color:", (0, _services.makeDisabledContrastColor)(euiTheme.colors.disabledText)(euiTheme.colors.disabled), ";background-color:", euiTheme.colors.disabled, ";;label:disabledAndSelected;"),
    // Content wrapper
    content: {
      euiButtonGroupButton__content: /*#__PURE__*/(0, _react.css)(";label:euiButtonGroupButton__content;"),
      compressed: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.s, ";;label:compressed;")
    },
    // Text wrapper
    text: {
      euiButtonGroupButton__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextShift)('bold', 'data-text', euiTheme), ";;label:euiButtonGroupButton__text;"),
      euiButtonGroupButton__iconOnly: /*#__PURE__*/(0, _react.css)((0, _accessibility.euiScreenReaderOnly)(), ";;label:euiButtonGroupButton__iconOnly;")
    }
  };
};

/**
 * Focus utilities - made complex by the two different button styles
 * and the fact that `label`/`input` combos need :focus-within,
 * but `button` does not
 */
exports.euiButtonGroupButtonStyles = euiButtonGroupButtonStyles;
var _outlineSelectors = function _outlineSelectors(outlineCss) {
  return /*#__PURE__*/(0, _react.css)("&:is(button){&:focus-visible{", outlineCss, ";}}&:is(label){&:focus-within{", outlineCss, ";}@supports selector(:has(*)){/* Once all evergreen browsers support :has, we can remove\n           @supports and the outline: none reset just use this selector */&:focus-within{outline:none;}&:has(:focus-visible){", outlineCss, ";}}}");
};
var _compressedButtonFocusColor = function _compressedButtonFocusColor(euiThemeContext, color) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiButtonFillColor = (0, _button.euiButtonFillColor)(euiThemeContext, color),
    backgroundColor = _euiButtonFillColor.backgroundColor;
  return _outlineSelectors("outline: ".concat(euiTheme.focus.width, " solid ").concat(backgroundColor, ";"));
};
exports._compressedButtonFocusColor = _compressedButtonFocusColor;
var _uncompressedButtonFocus = function _uncompressedButtonFocus(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return _outlineSelectors((0, _global_styling.euiOutline)(euiThemeContext, 'inset', euiTheme.colors.fullShade));
};
exports._uncompressedButtonFocus = _uncompressedButtonFocus;