"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiAccordionButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiAccordionButtonStyles = function euiAccordionButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiAccordion__button: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), " align-items:center;display:flex;flex-grow:1;line-height:", euiTheme.size.l, ";", (0, _global_styling.logicalTextAlignCSS)('left'), " ", (0, _global_styling.logicalCSS)('width', '100%'), " &:hover,&:focus{cursor:pointer;text-decoration:underline;};label:euiAccordion__button;"),
    // Triggering button needs separate `disabled` key because the element that renders may not support `:disabled`;
    // Hover pseudo selector for specificity
    disabled: /*#__PURE__*/(0, _react.css)("&,&:hover{cursor:not-allowed;color:", euiTheme.colors.disabledText, ";text-decoration:none;};label:disabled;"),
    // Optional padding sizes
    s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.l, ";;label:l;"),
    // Remove padding from the accordion button on the side that the arrow is on
    arrowLeft: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-left', 0), ";;label:arrowLeft;"),
    arrowRight: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-right', 0), ";;label:arrowRight;")
  };
};
exports.euiAccordionButtonStyles = euiAccordionButtonStyles;