"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionArrow = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _button = require("../../button");
var _accordion_arrow = require("./accordion_arrow.styles");
var _react2 = require("@emotion/react");
var _excluded = ["arrowDisplay", "arrowProps", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiAccordionArrow = function EuiAccordionArrow(_ref) {
  var _ref$arrowDisplay = _ref.arrowDisplay,
    arrowDisplay = _ref$arrowDisplay === void 0 ? 'left' : _ref$arrowDisplay,
    arrowProps = _ref.arrowProps,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  if (arrowDisplay === 'none') return null;
  var styles = (0, _accordion_arrow.euiAccordionArrowStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__arrow, styles[arrowDisplay], isOpen ? styles.isOpen : styles.isClosed, arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.css];
  var classes = (0, _classnames.default)('euiAccordion__arrow', arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.className);
  return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    color: "text"
  }, arrowProps, rest, {
    className: classes,
    css: cssStyles,
    iconType: "arrowRight"
  }));
};
exports.EuiAccordionArrow = EuiAccordionArrow;
EuiAccordionArrow.propTypes = {
  isOpen: _propTypes.default.bool.isRequired
};