"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.EuiAccordionClass = exports.EuiAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _loading = require("../loading");
var _accordion_trigger = require("./accordion_trigger");
var _accordion_children = require("./accordion_children");
var _accordion = require("./accordion.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "id", "element", "buttonElement", "buttonProps", "buttonClassName", "buttonContentClassName", "buttonContent", "arrowDisplay", "arrowProps", "extraAction", "paddingSize", "borders", "initialIsOpen", "forceState", "isLoading", "isLoadingMessage", "isDisabled", "theme"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
exports.PADDING_SIZES = PADDING_SIZES;
var EuiAccordionClass = /*#__PURE__*/function (_Component) {
  _inherits(EuiAccordionClass, _Component);
  var _super = _createSuper(EuiAccordionClass);
  function EuiAccordionClass() {
    var _this;
    _classCallCheck(this, EuiAccordionClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: _this.props.forceState ? _this.props.forceState === 'open' : _this.props.initialIsOpen
    });
    _defineProperty(_assertThisInitialized(_this), "onToggle", function () {
      var forceState = _this.props.forceState;
      if (forceState) {
        var _this$props$onToggle, _this$props;
        var nextState = !_this.isOpen;
        (_this$props$onToggle = (_this$props = _this.props).onToggle) === null || _this$props$onToggle === void 0 ? void 0 : _this$props$onToggle.call(_this$props, nextState);

        // If the accordion should theoretically be opened, wait a tick (allows
        // consumer state to update) and attempt to focus the child content.
        // NOTE: Even if the accordion does not actually open, this is fine -
        // the `inert` property on the hidden children will prevent focus
        if (nextState === true) {
          requestAnimationFrame(function () {
            var _this$accordionChildr;
            (_this$accordionChildr = _this.accordionChildrenEl) === null || _this$accordionChildr === void 0 ? void 0 : _this$accordionChildr.focus();
          });
        }
      } else {
        _this.setState(function (prevState) {
          return {
            isOpen: !prevState.isOpen
          };
        }, function () {
          var _this$props$onToggle2, _this$props2;
          (_this$props$onToggle2 = (_this$props2 = _this.props).onToggle) === null || _this$props$onToggle2 === void 0 ? void 0 : _this$props$onToggle2.call(_this$props2, _this.state.isOpen);

          // If the accordion is open, programmatically move focus
          // from the accordion trigger to the child content
          if (_this.state.isOpen) {
            var _this$accordionChildr2;
            (_this$accordionChildr2 = _this.accordionChildrenEl) === null || _this$accordionChildr2 === void 0 ? void 0 : _this$accordionChildr2.focus();
          }
        });
      }
    });
    // Used to focus the accordion children on user trigger click only (vs controlled/programmatic open)
    _defineProperty(_assertThisInitialized(_this), "accordionChildrenEl", null);
    _defineProperty(_assertThisInitialized(_this), "accordionChildrenRef", function (node) {
      _this.accordionChildrenEl = node;
    });
    _defineProperty(_assertThisInitialized(_this), "generatedId", (0, _services.htmlIdGenerator)()());
    return _this;
  }
  _createClass(EuiAccordionClass, [{
    key: "isOpen",
    get: function get() {
      return this.props.forceState ? this.props.forceState === 'open' : this.state.isOpen;
    }
  }, {
    key: "render",
    value: function render() {
      var _buttonProps$id;
      var _this$props3 = this.props,
        children = _this$props3.children,
        className = _this$props3.className,
        id = _this$props3.id,
        _this$props3$element = _this$props3.element,
        Element = _this$props3$element === void 0 ? 'div' : _this$props3$element,
        buttonElement = _this$props3.buttonElement,
        buttonProps = _this$props3.buttonProps,
        buttonClassName = _this$props3.buttonClassName,
        buttonContentClassName = _this$props3.buttonContentClassName,
        buttonContent = _this$props3.buttonContent,
        arrowDisplay = _this$props3.arrowDisplay,
        arrowProps = _this$props3.arrowProps,
        extraAction = _this$props3.extraAction,
        paddingSize = _this$props3.paddingSize,
        borders = _this$props3.borders,
        initialIsOpen = _this$props3.initialIsOpen,
        forceState = _this$props3.forceState,
        isLoading = _this$props3.isLoading,
        isLoadingMessage = _this$props3.isLoadingMessage,
        isDisabled = _this$props3.isDisabled,
        theme = _this$props3.theme,
        rest = _objectWithoutProperties(_this$props3, _excluded);
      var classes = (0, _classnames.default)('euiAccordion', {
        'euiAccordion-isOpen': this.isOpen
      }, className);
      var styles = (0, _accordion.euiAccordionStyles)(theme);
      var cssStyles = [styles.euiAccordion, borders !== 'none' && styles.borders.borders, borders !== 'none' && styles.borders[borders]];
      var buttonId = (_buttonProps$id = buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.id) !== null && _buttonProps$id !== void 0 ? _buttonProps$id : this.generatedId;
      return (0, _react2.jsx)(Element, _extends({
        className: classes,
        css: cssStyles
      }, rest), (0, _react2.jsx)(_accordion_trigger.EuiAccordionTrigger, {
        ariaControlsId: id,
        buttonId: buttonId
        // Force button element to be a legend if the element is a fieldset
        ,
        buttonElement: Element === 'fieldset' ? 'legend' : buttonElement,
        buttonClassName: buttonClassName,
        buttonContent: buttonContent,
        buttonContentClassName: buttonContentClassName,
        buttonProps: buttonProps,
        arrowProps: arrowProps,
        arrowDisplay: arrowDisplay,
        isDisabled: isDisabled,
        isOpen: this.isOpen,
        onToggle: this.onToggle,
        extraAction: isLoading ? (0, _react2.jsx)(_loading.EuiLoadingSpinner, null) : extraAction
      }), (0, _react2.jsx)(_accordion_children.EuiAccordionChildren, {
        id: id,
        "aria-labelledby": buttonId,
        paddingSize: paddingSize,
        isLoading: isLoading,
        isLoadingMessage: isLoadingMessage,
        isOpen: this.isOpen,
        accordionChildrenRef: this.accordionChildrenRef
      }, children));
    }
  }]);
  return EuiAccordionClass;
}(_react.Component);
exports.EuiAccordionClass = EuiAccordionClass;
_defineProperty(EuiAccordionClass, "defaultProps", {
  initialIsOpen: false,
  borders: 'none',
  paddingSize: 'none',
  arrowDisplay: 'left',
  isLoading: false,
  isDisabled: false,
  isLoadingMessage: false,
  element: 'div',
  buttonElement: 'button'
});
EuiAccordionClass.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  id: _propTypes.default.string.isRequired,
  /**
       * Applied to the entire .euiAccordion wrapper.
       * When using `fieldset`, it will enforce `buttonElement = legend` as well.
       */
  element: _propTypes.default.oneOf(["div", "fieldset"]),
  /**
       * Class that will apply to the trigger for the accordion.
       */
  buttonClassName: _propTypes.default.string,
  /**
       * Apply more props to the triggering button.
       *
       * Includes optional `paddingSize` prop which allows sizes of `s`, `m`, or `l`.
       * Note: Padding will not be present on the side closest to the accordion arrow.
       */
  buttonProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    paddingSize: _propTypes.default.oneOf(["s", "m", "l"])
  }),
  /**
       * Class that will apply to the trigger content for the accordion.
       */
  buttonContentClassName: _propTypes.default.string,
  /**
       * The content of the clickable trigger
       */
  buttonContent: _propTypes.default.node,
  /**
       * Applied to the main button receiving the `onToggle` event.
       * Anything other than the default `button` does not support removing the arrow display (for accessibility of focus).
       */
  buttonElement: _propTypes.default.oneOf(["div", "legend", "button"]),
  /**
       * Extra props to pass to the EuiButtonIcon containing the arrow.
       */
  arrowProps: _propTypes.default.any,
  /**
       * Will appear right aligned against the button. Useful for separate actions like deletions.
       */
  extraAction: _propTypes.default.node,
  /**
       * The accordion will start in the open state.
       */
  initialIsOpen: _propTypes.default.bool,
  /**
       * Optional callback method called on open and close with a single `isOpen` parameter
       */
  onToggle: _propTypes.default.func,
  /**
       * The padding around the exposed accordion content.
       */
  paddingSize: _propTypes.default.any,
  /**
       * Placement of the arrow indicator, or 'none' to hide it.
       */
  arrowDisplay: _propTypes.default.oneOf(["left", "right", "none"]),
  /**
       * Optional border styling. Defaults to 'none'.
       */
  borders: _propTypes.default.oneOf(["horizontal", "all", "none"]),
  /**
       * Control the opening of accordion via prop
       */
  forceState: _propTypes.default.oneOf(["closed", "open"]),
  /**
       * Change `extraAction` and children into a loading spinner
       */
  isLoading: _propTypes.default.bool,
  /**
       * Choose whether the loading message replaces the content. Customize the message by passing a node
       */
  isLoadingMessage: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.node.isRequired]),
  /**
       * Disable the open/close interaction and visually subdues the trigger
       */
  isDisabled: _propTypes.default.bool
};
var EuiAccordion = (0, _services.withEuiTheme)(EuiAccordionClass);
exports.EuiAccordion = EuiAccordion;