"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncoderMap = void 0;
class EncoderMap {
    [Symbol.toStringTag] = `[object EncoderMap]`;
    encoder;
    constructor(encoder) {
        this.encoder = new Map(encoder
            ? // eslint-disable-next-line unicorn/prefer-spread
                Array.from(encoder, ([key, value]) => [key.toString(), value])
            : undefined);
    }
    get size() {
        return this.encoder.size;
    }
    clear() {
        this.encoder.clear();
    }
    delete(key) {
        return this.encoder.delete(key.toString());
    }
    forEach(callbackfn) {
        this.encoder.forEach((value, key) => {
            callbackfn(value, new Uint8Array(key.split(',').map(Number)), this);
        });
    }
    get(key) {
        return this.encoder.get(key.toString());
    }
    getOrThrow(key) {
        const value = this.encoder.get(key.toString());
        if (typeof value === 'undefined') {
            // eslint-disable-next-line unicorn/prefer-type-error
            throw new Error(`The byte-pair encoding does not contain a value for: ${key.toString()}`);
        }
        return value;
    }
    has(key) {
        return this.encoder.has(key.toString());
    }
    set(key, value) {
        this.encoder.set(key.toString(), value);
        return this;
    }
    *entries() {
        for (const [key, value] of this.encoder.entries()) {
            yield [new Uint8Array(key.split(',').map(Number)), value];
        }
    }
    *keys() {
        for (const key of this.encoder.keys()) {
            yield new Uint8Array(key.split(',').map(Number));
        }
    }
    values() {
        return this.encoder.values();
    }
    [Symbol.iterator]() {
        return this.entries();
    }
}
exports.EncoderMap = EncoderMap;
//# sourceMappingURL=EncoderMap.js.map