"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatcherUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const licenseToLicenseStatus = license => {
  const {
    state,
    message
  } = license.check(_constants.PLUGIN.ID, _constants.PLUGIN.MINIMUM_LICENSE_REQUIRED);
  return {
    valid: state === 'valid' && license.getFeature(_constants.PLUGIN.ID).isAvailable,
    message
  };
};
class WatcherUIPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "capabilities$", new _rxjs.Subject());
  }
  setup({
    notifications,
    http,
    uiSettings,
    getStartServices
  }, {
    licensing,
    management,
    data,
    home,
    charts,
    licenseManagement
  }) {
    const esSection = management.sections.section.insightsAndAlerting;
    const pluginName = _i18n.i18n.translate('xpack.watcher.sections.watchList.managementSection.watcherDisplayName', {
      defaultMessage: 'Watcher'
    });
    const watcherESApp = esSection.registerApp({
      id: 'watcher',
      title: pluginName,
      order: 5,
      mount: async ({
        element,
        setBreadcrumbs,
        history,
        theme$
      }) => {
        const [coreStart] = await getStartServices();
        const {
          chrome: {
            docTitle
          },
          i18n: i18nDep,
          docLinks,
          application,
          executionContext,
          settings
        } = coreStart;
        docTitle.change(pluginName);
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const {
          TimeBuckets
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./legacy')));
        const unmountAppCallback = renderApp({
          // Skip the first license status, because that's already been used to determine
          // whether to include Watcher.
          licenseStatus$: licensing.license$.pipe((0, _operators.skip)(1), (0, _operators.map)(licenseToLicenseStatus)),
          element,
          toasts: notifications.toasts,
          http,
          uiSettings,
          settings,
          docLinks,
          setBreadcrumbs,
          theme: charts.theme,
          I18nContext: i18nDep.Context,
          createTimeBuckets: () => new TimeBuckets(uiSettings, data),
          history,
          getUrlForApp: application.getUrlForApp,
          theme$,
          licenseManagementLocator: licenseManagement === null || licenseManagement === void 0 ? void 0 : licenseManagement.locator,
          executionContext
        });
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });

    // TODO: Fix the below dependency on `home` plugin inner workings
    // Because the home feature catalogue does not have enable/disable functionality we pass
    // the config in but keep a reference for enabling and disabling showing on home based on
    // license updates.
    const watcherHome = {
      id: 'watcher',
      title: 'Watcher',
      // This is a product name so we don't translate it.
      category: 'admin',
      description: _i18n.i18n.translate('xpack.watcher.watcherDescription', {
        defaultMessage: 'Detect changes in your data by creating, managing, and monitoring alerts.'
      }),
      icon: 'watchesApp',
      path: '/app/management/insightsAndAlerting/watcher/watches',
      showOnHomePage: false
    };
    home.featureCatalogue.register(watcherHome);
    (0, _rxjs.combineLatest)([licensing.license$.pipe((0, _operators.first)(), (0, _operators.map)(licenseToLicenseStatus)), this.capabilities$]).subscribe(([{
      valid
    }, capabilities]) => {
      var _capabilities$managem;
      // NOTE: We enable the plugin by default instead of disabling it by default because this
      // creates a race condition that can cause the app nav item to not render in the side nav.
      // The race condition still exists, but it will result in the item rendering when it shouldn't
      // (e.g. on a license it's not available for), instead of *not* rendering when it *should*,
      // which is a less frustrating UX.
      if (valid && ((_capabilities$managem = capabilities.management.insightsAndAlerting) === null || _capabilities$managem === void 0 ? void 0 : _capabilities$managem.watcher) === true) {
        watcherESApp.enable();
      } else {
        watcherESApp.disable();
      }
    });
  }
  start(core) {
    this.capabilities$.next(core.application.capabilities);
  }
  stop() {}
}
exports.WatcherUIPlugin = WatcherUIPlugin;