"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdWatchEdit = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _serialization = require("../../../../../../common/lib/serialization");
var _components = require("../../../../components");
var _api = require("../../../../lib/api");
var _agg_types = require("../../../../models/watch/agg_types");
var _group_by_types = require("../../../../models/watch/group_by_types");
var _comparators = require("../../../../models/watch/comparators");
var _watch_edit_actions = require("../../watch_edit_actions");
var _watch_context = require("../../watch_context");
var _watch_visualization = require("./watch_visualization");
var _threshold_watch_action_panel = require("./threshold_watch_action_panel");
var _get_time_unit_label = require("../../../../lib/get_time_unit_label");
var _navigation = require("../../../../lib/navigation");
var _request_flyout = require("../request_flyout");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expressionFieldsWithValidation = ['aggField', 'termSize', 'termField', 'threshold0', 'threshold1', 'timeWindowSize'];
const expressionFields = ['aggType', 'aggField', 'termSize', 'termField', 'thresholdComparator', 'timeWindowSize', 'timeWindowUnit', 'triggerIntervalSize', 'triggerIntervalUnit', 'threshold', 'groupBy'];
const expressionErrorMessage = _i18n.i18n.translate('xpack.watcher.thresholdWatchExpression.fixErrorInExpressionBelowValidationMessage', {
  defaultMessage: 'Expression contains errors.'
});
const firstFieldOption = {
  text: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.timeFieldOptionLabel', {
    defaultMessage: 'Select a field'
  }),
  value: ''
};
const getTimeOptions = unitSize => Object.entries(_constants.TIME_UNITS).map(([_key, value]) => {
  return {
    text: (0, _get_time_unit_label.getTimeUnitLabel)(value, unitSize),
    value
  };
});
const getFields = async indices => {
  return await (0, _api.fetchFields)(indices);
};
const getTimeFieldOptions = fields => {
  const options = [firstFieldOption];
  fields.forEach(field => {
    if (field.type === 'date') {
      options.push({
        text: field.name,
        value: field.name
      });
    }
  });
  return options;
};
const getIndexOptions = async (patternString, indexPatterns) => {
  const options = [];
  if (!patternString) {
    return options;
  }
  const matchingIndices = await (0, _api.getMatchingIndices)(patternString);
  const matchingIndexPatterns = indexPatterns.filter(anIndexPattern => {
    return anIndexPattern.includes(patternString);
  });
  if (matchingIndices.length || matchingIndexPatterns.length) {
    const matchingOptions = _lodash.default.uniq([...matchingIndices, ...matchingIndexPatterns]);
    options.push({
      label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.indicesAndIndexPatternsLabel', {
        defaultMessage: 'Based on your indices and index patterns'
      }),
      options: matchingOptions.map(match => {
        return {
          label: match,
          value: match
        };
      }).sort((a, b) => String(a.label).localeCompare(b.label))
    });
  }
  options.push({
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.chooseLabel', {
      defaultMessage: 'Choose…'
    }),
    options: [{
      key: 'UNIQUE_CHOOSE_KEY',
      value: patternString,
      label: patternString
    }]
  });
  return options;
};
const ThresholdWatchEdit = ({
  pageTitle
}) => {
  // hooks
  const {
    toasts
  } = (0, _app_context.useAppContext)();
  const [indexPatterns, setIndexPatterns] = (0, _react.useState)([]);
  const [esFields, setEsFields] = (0, _react.useState)([]);
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([firstFieldOption]);
  const [aggFieldPopoverOpen, setAggFieldPopoverOpen] = (0, _react.useState)(false);
  const [groupByPopoverOpen, setGroupByPopoverOpen] = (0, _react.useState)(false);
  const [watchThresholdPopoverOpen, setWatchThresholdPopoverOpen] = (0, _react.useState)(false);
  const [watchDurationPopoverOpen, setWatchDurationPopoverOpen] = (0, _react.useState)(false);
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  const [serverError, setServerError] = (0, _react.useState)(null);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [isIndiciesLoading, setIsIndiciesLoading] = (0, _react.useState)(false);
  const [isRequestVisible, setIsRequestVisible] = (0, _react.useState)(false);
  const {
    watch,
    setWatchProperty
  } = (0, _react.useContext)(_watch_context.WatchContext);
  (0, _react.useEffect)(() => {
    const getIndexPatterns = async () => {
      const {
        data: indexPatternTitles
      } = await (0, _api.loadIndexPatterns)();
      setIndexPatterns(indexPatternTitles);
    };
    const loadData = async () => {
      if (watch.index && watch.index.length > 0) {
        const allEsFields = await getFields(watch.index);
        const timeFields = getTimeFieldOptions(allEsFields);
        setEsFields(allEsFields);
        setTimeFieldOptions(timeFields);
        setWatchProperty('timeFields', timeFields);
      }
      getIndexPatterns();
    };
    loadData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    errors
  } = watch.validate();
  const hasErrors = !!Object.keys(errors).find(errorKey => errors[errorKey].length >= 1);
  const actionErrors = watch.actions.reduce((acc, action) => {
    const actionValidationErrors = action.validate();
    acc[action.id] = actionValidationErrors;
    return acc;
  }, {});
  const hasActionErrors = !!Object.keys(actionErrors).find(actionError => {
    return !!Object.keys(actionErrors[actionError]).find(actionErrorKey => {
      return actionErrors[actionError][actionErrorKey].length >= 1;
    });
  });
  const hasExpressionErrors = !!Object.keys(errors).find(errorKey => expressionFieldsWithValidation.includes(errorKey) && errors[errorKey].length >= 1);
  const shouldShowThresholdExpression = watch.index && watch.index.length > 0 && watch.timeField;
  const andThresholdText = _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.andLabel', {
    defaultMessage: 'AND'
  });

  // Users might edit the request for use outside of the Watcher app. If they do make changes to it,
  // we have no guarantee it will still be compatible with the threshold alert form, so we strip
  // the metadata to avoid potential conflicts.
  const requestPreviewWatchData = {
    ...watch.upstreamJson,
    includeMetadata: false
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, pageTitle),
    description: watch.titleDescription,
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "thresholdWatchForm"
  }, serverError && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.json.saveWatchErrorTitle",
      defaultMessage: "Error saving watch"
    }),
    error: serverError
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "watchName",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.watchNameLabel",
      defaultMessage: "Name"
    }),
    errorKey: "name",
    isShowingErrors: hasErrors && watch.name !== undefined,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    "data-test-subj": "nameInput",
    value: watch.name || '',
    onChange: e => {
      setWatchProperty('name', e.target.value);
    },
    onBlur: () => {
      if (!watch.name) {
        setWatchProperty('name', '');
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "indexSelectSearchBox",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.indicesToQueryLabel",
      defaultMessage: "Indices to query"
    }),
    errorKey: "index",
    isShowingErrors: hasErrors && watch.index !== undefined,
    errors: errors,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.howToBroadenSearchQueryDescription",
      defaultMessage: "Use * to broaden your query."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    async: true,
    isLoading: isIndiciesLoading,
    noSuggestions: !indexOptions.length,
    options: indexOptions,
    "data-test-subj": "indicesComboBox",
    selectedOptions: (watch.index || []).map(anIndex => {
      return {
        label: anIndex,
        value: anIndex
      };
    }),
    onChange: async selected => {
      setWatchProperty('index', selected.map(aSelected => aSelected.value));
      const indices = selected.map(s => s.value);

      // reset time field and expression fields if indices are deleted
      if (indices.length === 0) {
        setTimeFieldOptions(getTimeFieldOptions([]));
        setWatchProperty('timeFields', []);
        expressionFields.forEach(expressionField => {
          setWatchProperty(expressionField, null);
        });
        return;
      }
      const currentEsFields = await getFields(indices);
      const timeFields = getTimeFieldOptions(currentEsFields);
      setEsFields(currentEsFields);
      setWatchProperty('timeFields', timeFields);
      setTimeFieldOptions(timeFields);
    },
    onSearchChange: async search => {
      setIsIndiciesLoading(true);
      setIndexOptions(await getIndexOptions(search, indexPatterns));
      setIsIndiciesLoading(false);
    },
    onBlur: () => {
      if (!watch.index) {
        setWatchProperty('index', []);
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "timeField",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.timeFieldLabel",
      defaultMessage: "Time field"
    }),
    errorKey: "timeField",
    isShowingErrors: hasErrors && watch.timeField !== undefined,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeFieldOptions,
    fullWidth: true,
    name: "watchTimeField",
    "data-test-subj": "watchTimeFieldSelect",
    value: watch.timeField,
    onChange: e => {
      setWatchProperty('timeField', e.target.value);
    },
    onBlur: () => {
      if (watch.timeField === undefined) {
        setWatchProperty('timeField', '');
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    id: "watchInterval",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.titlePanel.watchIntervalLabel",
      defaultMessage: "Run watch every"
    }),
    errorKey: "triggerIntervalSize",
    isShowingErrors: hasErrors && watch.triggerIntervalSize !== undefined,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    value: watch.triggerIntervalSize,
    "data-test-subj": "triggerIntervalSizeInput",
    onChange: e => {
      const {
        value
      } = e.target;
      const triggerIntervalSize = value !== '' ? parseInt(value, 10) : value;
      setWatchProperty('triggerIntervalSize', triggerIntervalSize);
    },
    onBlur: e => {
      if (watch.triggerIntervalSize === undefined) {
        setWatchProperty('triggerIntervalSize', '');
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    value: watch.triggerIntervalUnit,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchEdit.titlePanel.durationAriaLabel', {
      defaultMessage: 'Duration time unit'
    }),
    onChange: e => {
      setWatchProperty('triggerIntervalUnit', e.target.value);
    },
    options: getTimeOptions(watch.triggerIntervalSize)
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), shouldShowThresholdExpression ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "watchConditionTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.watchConditionSectionTitle",
    defaultMessage: "Match the following condition"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "aggTypePopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.whenLabel', {
        defaultMessage: 'when'
      }),
      value: _agg_types.aggTypes[watch.aggType].text,
      isActive: aggTypePopoverOpen,
      onClick: () => {
        setAggTypePopoverOpen(true);
      }
    }),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.whenButtonLabel', {
    defaultMessage: 'when'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.aggType,
    onChange: e => {
      setWatchProperty('aggType', e.target.value);
      setAggTypePopoverOpen(false);
    },
    options: Object.values(_agg_types.aggTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    })
  })))), watch.aggType && _agg_types.aggTypes[watch.aggType].fieldRequired ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "aggFieldPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.ofLabel', {
        defaultMessage: 'of'
      }),
      value: watch.aggField || firstFieldOption.text,
      isActive: aggFieldPopoverOpen || !watch.aggField,
      onClick: () => {
        setAggFieldPopoverOpen(true);
      },
      color: watch.aggField ? 'success' : 'danger'
    }),
    isOpen: aggFieldPopoverOpen,
    closePopover: () => {
      setAggFieldPopoverOpen(false);
    },
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.ofButtonLabel', {
    defaultMessage: 'of'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "watcherThresholdAlertAggFieldContainer"
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "aggField",
    isShowingErrors: hasErrors && watch.aggField !== undefined,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    placeholder: firstFieldOption.text,
    options: esFields.reduce((esFieldOptions, field) => {
      if (_agg_types.aggTypes[watch.aggType].validNormalizedTypes.includes(field.normalizedType)) {
        esFieldOptions.push({
          label: field.name
        });
      }
      return esFieldOptions;
    }, []),
    selectedOptions: watch.aggField ? [{
      label: watch.aggField
    }] : [],
    onChange: selectedOptions => {
      setWatchProperty('aggField', selectedOptions.length === 1 ? selectedOptions[0].label : undefined);
      setAggFieldPopoverOpen(false);
    }
  }))))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "groupByPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: `${_group_by_types.groupByTypes[watch.groupBy].sizeRequired ? _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.groupedOverLabel', {
        defaultMessage: 'grouped over'
      }) : _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.overLabel', {
        defaultMessage: 'over'
      })}`,
      value: `${_group_by_types.groupByTypes[watch.groupBy].text} ${_group_by_types.groupByTypes[watch.groupBy].sizeRequired ? `${watch.termSize || ''} ${watch.termField ? `'${watch.termField}'` : ''}` : ''}`,
      isActive: groupByPopoverOpen || watch.groupBy === 'top' && !(watch.termSize && watch.termField),
      onClick: () => {
        setGroupByPopoverOpen(true);
      },
      color: watch.groupBy === 'all' || watch.termSize && watch.termField ? 'success' : 'danger'
    }),
    isOpen: groupByPopoverOpen,
    closePopover: () => {
      setGroupByPopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.overButtonLabel', {
    defaultMessage: 'over'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.groupBy,
    onChange: e => {
      setWatchProperty('termSize', null);
      setWatchProperty('termField', null);
      setWatchProperty('groupBy', e.target.value);
    },
    options: Object.values(_group_by_types.groupByTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    })
  })), _group_by_types.groupByTypes[watch.groupBy].sizeRequired ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "termSize",
    isShowingErrors: hasErrors,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: watch.termSize,
    onChange: e => {
      setWatchProperty('termSize', e.target.value);
    },
    min: 1
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "termField",
    isShowingErrors: hasErrors && watch.termField !== undefined,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.termField || '',
    onChange: e => {
      setWatchProperty('termField', e.target.value);
    },
    options: esFields.reduce((options, field) => {
      if (_group_by_types.groupByTypes[watch.groupBy].validNormalizedTypes.includes(field.normalizedType)) {
        options.push({
          text: field.name,
          value: field.name
        });
      }
      return options;
    }, [firstFieldOption])
  })))) : null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "watchThresholdPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "watchThresholdButton",
      description: _comparators.comparators[watch.thresholdComparator].text,
      value: watch.threshold.slice(0, _comparators.comparators[watch.thresholdComparator].requiredValues).join(` ${andThresholdText} `),
      isActive: Boolean(watchThresholdPopoverOpen || errors.threshold0.length || errors.threshold1 && errors.threshold1.length),
      onClick: () => {
        setWatchThresholdPopoverOpen(true);
      },
      color: errors.threshold0.length || errors.threshold1 && errors.threshold1.length ? 'danger' : 'success'
    }),
    isOpen: watchThresholdPopoverOpen,
    closePopover: () => {
      setWatchThresholdPopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _comparators.comparators[watch.thresholdComparator].text), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.thresholdComparator,
    onChange: e => {
      setWatchProperty('thresholdComparator', e.target.value);
    },
    options: Object.values(_comparators.comparators).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    })
  })), Array.from(Array(_comparators.comparators[watch.thresholdComparator].requiredValues)).map((_notUsed, i) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `threshold${i}`
    }, i > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "watcherThresholdWatchInBetweenComparatorText"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, andThresholdText), hasErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
      errorKey: `threshold${i}`,
      isShowingErrors: hasErrors,
      errors: errors
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "watchThresholdInput",
      value: watch.threshold[i] == null ? '' : watch.threshold[i],
      min: 0,
      step: 0.1,
      onChange: e => {
        const {
          value
        } = e.target;
        const threshold = value !== '' ? parseFloat(value) : value;
        const newThreshold = [...watch.threshold];
        newThreshold[i] = threshold;
        setWatchProperty('threshold', newThreshold);
      }
    }))));
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "watchDurationPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.forTheLastLabel', {
        defaultMessage: 'for the last'
      }),
      value: `${watch.timeWindowSize} ${(0, _get_time_unit_label.getTimeUnitLabel)(watch.timeWindowUnit, parseInt(watch.timeWindowSize, 10).toString())}`,
      isActive: watchDurationPopoverOpen || !watch.timeWindowSize,
      onClick: () => {
        setWatchDurationPopoverOpen(true);
      },
      color: watch.timeWindowSize ? 'success' : 'danger'
    }),
    isOpen: watchDurationPopoverOpen,
    closePopover: () => {
      setWatchDurationPopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.threshold.forTheLastButtonLabel",
    defaultMessage: "For the last"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ErrableFormRow, {
    errorKey: "timeWindowSize",
    isShowingErrors: hasErrors,
    errors: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    min: 1,
    value: watch.timeWindowSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const timeWindowSize = value !== '' ? parseInt(value, 10) : value;
      setWatchProperty('timeWindowSize', timeWindowSize);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: watch.timeWindowUnit,
    onChange: e => {
      setWatchProperty('timeWindowUnit', e.target.value);
    },
    options: getTimeOptions(watch.timeWindowSize)
  }))))))), hasExpressionErrors ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, expressionErrorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, hasErrors ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_watch_visualization.WatchVisualization, null), /*#__PURE__*/_react.default.createElement(_threshold_watch_action_panel.WatchActionsPanel, {
    actionErrors: actionErrors
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    "data-test-subj": "saveWatchButton",
    type: "submit",
    iconType: "check",
    disabled: hasErrors || hasActionErrors,
    isLoading: isSaving,
    onClick: async () => {
      setIsSaving(true);
      const savedWatch = await (0, _watch_edit_actions.onWatchSave)(watch, toasts);
      if (savedWatch && savedWatch.error) {
        setIsSaving(false);
        return setServerError(savedWatch.error);
      }
    }
  }, watch.isNew ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.threshold.createButtonLabel",
    defaultMessage: "Create alert"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.threshold.saveButtonLabel",
    defaultMessage: "Save alert"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => (0, _navigation.goToWatchList)()
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsRequestVisible(!isRequestVisible)
  }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.hideRequestButtonLabel",
    defaultMessage: "Hide request"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.json.showRequestButtonLabel",
    defaultMessage: "Show request"
  }))))), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
    id: watch.id,
    payload: (0, _serialization.serializeThresholdWatch)(requestPreviewWatchData),
    close: () => setIsRequestVisible(false)
  }) : null);
};
exports.ThresholdWatchEdit = ThresholdWatchEdit;