"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppContext = exports.AppContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppContext = /*#__PURE__*/(0, _react.createContext)(null);
const generateDocLinks = ({
  links
}) => {
  const putWatchApiUrl = `${links.apis.putWatch}`;
  const executeWatchApiUrl = `${links.apis.executeWatchActionModes}`;
  const watcherGettingStartedUrl = `${links.watcher.ui}`;
  const watchActionsConfigurationMap = {
    [_constants.ACTION_TYPES.SLACK]: `${links.watcher.slackAction}`,
    [_constants.ACTION_TYPES.PAGERDUTY]: `${links.watcher.pagerDutyAction}`,
    [_constants.ACTION_TYPES.JIRA]: `${links.watcher.jiraAction}`
  };
  return {
    putWatchApiUrl,
    executeWatchApiUrl,
    watcherGettingStartedUrl,
    watchActionsConfigurationMap
  };
};
const AppContextProvider = ({
  children,
  value
}) => {
  const {
    docLinks,
    ...rest
  } = value;
  return /*#__PURE__*/_react.default.createElement(AppContext.Provider, {
    value: Object.freeze({
      ...rest,
      links: generateDocLinks(docLinks)
    })
  }, children);
};
exports.AppContextProvider = AppContextProvider;
const useAppContext = () => {
  const ctx = (0, _react.useContext)(AppContext);
  if (!ctx) {
    throw new Error('"useAppContext" can only be called inside of AppContext.Provider!');
  }
  return ctx;
};
exports.useAppContext = useAppContext;