"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeriesParams = void 0;
var _types = require("../types");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const makeSerie = (id, label, defaultValueAxis, lastSerie) => {
  const data = {
    id,
    label
  };
  const defaultSerie = {
    show: true,
    mode: _types.ChartMode.Normal,
    type: _common.ChartType.Line,
    drawLinesBetweenPoints: true,
    showCircles: true,
    circlesRadius: 1,
    interpolate: _types.InterpolationMode.Linear,
    lineWidth: 2,
    valueAxis: defaultValueAxis
  };
  return {
    ...defaultSerie,
    ...lastSerie,
    data
  };
};
const getSeriesParams = (aggs, seriesParams, schemaName, firstValueAxesId) => {
  const metrics = aggs === null || aggs === void 0 ? void 0 : aggs.bySchemaName(schemaName);
  return metrics === null || metrics === void 0 ? void 0 : metrics.map(agg => {
    const params = seriesParams.find(param => param.data.id === agg.id);
    const label = agg.makeLabel();

    // update labels for existing params or create new one
    if (params) {
      return {
        ...params,
        data: {
          ...params.data,
          label
        }
      };
    } else {
      const series = makeSerie(agg.id, label, firstValueAxesId, seriesParams[seriesParams.length - 1]);
      return series;
    }
  });
};
exports.getSeriesParams = getSeriesParams;