"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chartTitleSplit = chartTitleSplit;
var _d = _interopRequireDefault(require("d3"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Adds div DOM elements to either the `.visAxis__splitTitles--y` element or the
 * `.visAxis__splitTitles--x` element based on the data layout.
 * For example, if the data has rows, it returns the same number of
 * `.chart-title` elements as row objects.
 * if not data.rows or data.columns, return no chart titles
 */

function chartTitleSplit(selection, parent) {
  selection.each(function (data) {
    const div = _d.default.select(this);
    if (!data.slices) {
      div.selectAll('.chart-title').append('div').data(function (d) {
        return d.rows ? d.rows : d.columns;
      }).enter().append('div').attr('class', 'chart-title');
      if (data.rows) {
        _d.default.select(parent).select('.visAxis__splitTitles--x').remove();
      } else {
        _d.default.select(parent).select('.visAxis__splitTitles--y').remove();
      }
      return div;
    }
    return _d.default.select(this).remove();
  });
}