"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenSeries = flattenSeries;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Accepts a Kibana data object with a rows or columns key
 * and returns an array of flattened series values.
 */
function flattenSeries(obj) {
  if (!_lodash.default.isObject(obj) || !obj.rows && !obj.columns) {
    throw new TypeError('GetSeriesUtilService expects an object with either a rows or columns key');
  }
  obj = obj.rows ? obj.rows : obj.columns;
  return _lodash.default.chain(obj).map('series').flattenDeep().value();
}