"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./vega_data_inspector.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dataSetsLabel = _i18n.i18n.translate('visTypeVega.inspector.dataSetsLabel', {
  defaultMessage: 'Data sets'
});
const signalValuesLabel = _i18n.i18n.translate('visTypeVega.inspector.signalValuesLabel', {
  defaultMessage: 'Signal values'
});
const specLabel = _i18n.i18n.translate('visTypeVega.inspector.specLabel', {
  defaultMessage: 'Spec'
});
const VegaDataInspector = ({
  adapters
}) => {
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const subscription = adapters.vega.getErrorObservable().subscribe(data => {
      setError(data);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [adapters.vega]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('visTypeVega.inspector.errorHeading', {
        defaultMessage: `Vega didn't render successfully`
      }),
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, error));
  }
  const tabs = [{
    id: 'data-viewer--id',
    name: dataSetsLabel,
    content: /*#__PURE__*/_react.default.createElement(_components.DataViewer, {
      vegaAdapter: adapters.vega
    }),
    'data-test-subj': 'vegaDataInspectorDataViewerButton'
  }, {
    id: 'signal-viewer--id',
    name: signalValuesLabel,
    content: /*#__PURE__*/_react.default.createElement(_components.SignalViewer, {
      vegaAdapter: adapters.vega
    }),
    'data-test-subj': 'vegaDataInspectorSignalViewerButton'
  }, {
    id: 'spec-viewer--id',
    name: specLabel,
    content: /*#__PURE__*/_react.default.createElement(_components.SpecViewer, {
      className: "vgaVegaDataInspector__specViewer",
      vegaAdapter: adapters.vega
    }),
    'data-test-subj': 'vegaDataInspectorSpecViewerButton'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    className: "vgaVegaDataInspector",
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  });
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = VegaDataInspector;
module.exports = exports.default;