"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIntervalBasedFormatter = createIntervalBasedFormatter;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const JANUARY_MOMENT_CONFIG = {
  M: 0,
  d: 1
};
function getFormat(interval, rules = []) {
  for (let i = rules.length - 1; i >= 0; i--) {
    const rule = rules[i];
    if (!rule[0] || interval >= Number(_moment.default.duration(rule[0]))) {
      return rule[1];
    }
  }
}
function createIntervalBasedFormatter(interval, rules, dateFormat, ignoreDaylightTime) {
  const fixedOffset = (0, _moment.default)(JANUARY_MOMENT_CONFIG).utcOffset();
  return val => {
    var _getFormat;
    const momentVal = (0, _moment.default)(val);
    if (ignoreDaylightTime) {
      momentVal.utcOffset(fixedOffset);
    }
    return momentVal.format((_getFormat = getFormat(interval, rules)) !== null && _getFormat !== void 0 ? _getFormat : dateFormat);
  };
}