"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLens = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _uuid = require("uuid");
var _services = require("../services");
var _configurations = require("./configurations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToLens = async (vis, timefilter) => {
  var _vis$data$indexPatter;
  if (!timefilter) {
    return null;
  }
  const dataViews = (0, _services.getDataViewsStart)();
  const dataView = await (0, _public.getDataViewByIndexPatternId)((_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id, dataViews);
  if (!dataView) {
    return null;
  }
  const {
    getColumnsFromVis
  } = await _public.convertToLensModule;
  const layers = getColumnsFromVis(vis, timefilter, dataView, {
    buckets: [],
    splits: ['segment'],
    unsupported: ['split_row', 'split_column']
  });
  if (layers === null) {
    return null;
  }
  const [layerConfig] = layers;

  // doesn't support more than three split slice levels
  // doesn't support pie without at least one split slice
  if (layerConfig.buckets.all.length > 3 || !layerConfig.buckets.all.length) {
    return null;
  }
  const layerId = (0, _uuid.v4)();
  const indexPatternId = dataView.id;
  return {
    type: 'lnsPie',
    layers: [{
      indexPatternId,
      layerId,
      columns: layerConfig.columns.map(_convert_to_lens.excludeMetaFromColumn),
      columnOrder: [],
      ignoreGlobalFilters: false
    }],
    configuration: (0, _configurations.getConfiguration)(layerId, vis, layerConfig),
    indexPatternIds: [indexPatternId]
  };
};
exports.convertToLens = convertToLens;