"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UxPlugin = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
async function getDataStartPlugin(core) {
  const [_, startPlugins] = await core.getStartServices();
  return startPlugins.data;
}
class UxPlugin {
  constructor(initContext) {
    this.initContext = initContext;
  }
  setup(core, plugins) {
    const pluginSetupDeps = plugins;
    if (plugins.observability) {
      const getUxDataHelper = async () => {
        const {
          fetchUxOverviewDate,
          hasRumData,
          createCallApmApi
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/app/rum_dashboard/ux_overview_fetchers')));
        // have to do this here as well in case app isn't mounted yet
        createCallApmApi(core);
        return {
          fetchUxOverviewDate,
          hasRumData
        };
      };
      plugins.observability.dashboard.register({
        appName: 'ux',
        hasData: async params => {
          const dataHelper = await getUxDataHelper();
          const dataStartPlugin = await getDataStartPlugin(core);
          return dataHelper.hasRumData({
            ...params,
            dataStartPlugin
          });
        },
        fetchData: async params => {
          const dataStartPlugin = await getDataStartPlugin(core);
          const dataHelper = await getUxDataHelper();
          return dataHelper.fetchUxOverviewDate({
            ...params,
            dataStartPlugin
          });
        }
      });
      plugins.exploratoryView.register({
        appName: 'ux',
        hasData: async params => {
          const dataHelper = await getUxDataHelper();
          const dataStartPlugin = await getDataStartPlugin(core);
          return dataHelper.hasRumData({
            ...params,
            dataStartPlugin
          });
        },
        fetchData: async params => {
          const dataStartPlugin = await getDataStartPlugin(core);
          const dataHelper = await getUxDataHelper();
          return dataHelper.fetchUxOverviewDate({
            ...params,
            dataStartPlugin
          });
        }
      });
    }

    // register observability nav if user has access to plugin
    plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _operators.map)(([coreStart]) => {
      // checking apm capability, since ux for now doesn't have it's
      // own capability
      if (coreStart.application.capabilities.apm.show) {
        return [
        // UX navigation
        {
          label: 'User Experience',
          sortKey: 600,
          entries: [{
            label: _i18n.i18n.translate('xpack.ux.overview.heading', {
              defaultMessage: 'Dashboard'
            }),
            app: 'ux',
            path: '/',
            matchFullPath: true,
            ignoreTrailingSlash: true
          }]
        }];
      }
      return [];
    })));
    const isDev = this.initContext.env.mode.dev;
    core.application.register({
      id: 'ux',
      title: 'User Experience',
      order: 8500,
      euiIconType: 'logoObservability',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      // navLinkStatus: config.ui.enabled
      //   ? AppNavLinkStatus.default
      //   : AppNavLinkStatus.hidden,
      keywords: ['RUM', 'Real User Monitoring', 'DEM', 'Digital Experience Monitoring', 'EUM', 'End User Monitoring', 'UX', 'Javascript', 'APM', 'Mobile', 'digital', 'performance', 'web performance', 'web perf'],
      async mount(appMountParameters) {
        // Load application bundle and Get start service
        const [{
          renderApp
        }, [coreStart, corePlugins]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application/ux_app'))), core.getStartServices()]);
        return renderApp({
          isDev,
          core: coreStart,
          deps: pluginSetupDeps,
          appMountParameters,
          corePlugins: corePlugins
        });
      }
    });
  }
  start(core, plugins) {}
}
exports.UxPlugin = UxPlugin;