"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceNameFilter = ServiceNameFilter;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _use_url_params = require("../../../../../context/url_params_context/use_url_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceNameFilter({
  loading,
  serviceNames
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      serviceName: selectedServiceName
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const options = (serviceNames !== null && serviceNames !== void 0 ? serviceNames : []).map(type => ({
    text: type,
    value: type
  }));
  const updateServiceName = (0, _react.useCallback)((serviceN, replaceHistory) => {
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)({
        ...(0, _public.toQuery)(history.location.search),
        serviceName: serviceN
      })
    };
    if (replaceHistory) {
      history.replace(newLocation);
    } else {
      history.push(newLocation);
    }
  }, [history]);
  (0, _react.useEffect)(() => {
    if (serviceNames && (serviceNames === null || serviceNames === void 0 ? void 0 : serviceNames.length) > 0) {
      // select first from the list
      if (!selectedServiceName) {
        updateServiceName(serviceNames[0], true);
      }

      // in case serviceName is cached from url and isn't present in current list
      if (selectedServiceName && !serviceNames.includes(selectedServiceName)) {
        updateServiceName(serviceNames[0], true);
      }
    }
    if (selectedServiceName && (serviceNames === null || serviceNames === void 0 ? void 0 : serviceNames.length) === 0 && !loading) {
      updateServiceName('');
    }
  }, [serviceNames, selectedServiceName, updateServiceName, loading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "uxServiceNameFilterSelect",
    fullWidth: true,
    prepend: _i18n.i18n.translate('xpack.ux.localFilters.titles.webApplication', {
      defaultMessage: 'Web application'
    }),
    isLoading: loading,
    "data-cy": "serviceNameFilter",
    options: options,
    value: selectedServiceName,
    onChange: event => {
      updateServiceName(event.target.value);
    }
  });
}