"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfilesPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _user_profiles_selectable = require("./user_profiles_selectable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Props of {@link UserProfilesPopover} component
 */

/**
 * Renders a selectable component inside a popover given a list of user profiles
 */
const UserProfilesPopover = ({
  title,
  selectableProps,
  ...popoverProps
}) => {
  const searchInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'searchInput',
    conditionalId: selectableProps.searchInputId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    panelPaddingSize: "none",
    initialFocus: `#${searchInputId}`
  }, popoverProps), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    title: title
  }, /*#__PURE__*/_react.default.createElement(_user_profiles_selectable.UserProfilesSelectable, (0, _extends2.default)({}, selectableProps, {
    searchInputId: searchInputId
  }))));
};
exports.UserProfilesPopover = UserProfilesPopover;