"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfilesProvider = exports.UserProfilesKibanaProvider = void 0;
exports.useUserProfiles = useUserProfiles;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UserProfilesContext = /*#__PURE__*/_react.default.createContext(null);

/**
 * Abstract external service Provider.
 */
const UserProfilesProvider = ({
  children,
  ...services
}) => {
  return /*#__PURE__*/_react.default.createElement(UserProfilesContext.Provider, {
    value: services
  }, children);
};

/**
 * Kibana-specific service types.
 */
exports.UserProfilesProvider = UserProfilesProvider;
/**
 * Kibana-specific Provider that maps to known dependency types.
 */
const UserProfilesKibanaProvider = ({
  children,
  ...services
}) => {
  const {
    core: {
      notifications,
      theme
    },
    security: {
      userProfiles: userProfileApiClient
    },
    toMountPoint
  } = services;
  return /*#__PURE__*/_react.default.createElement(UserProfilesProvider, {
    userProfileApiClient: userProfileApiClient,
    notifySuccess: ({
      title,
      text
    }, options) => {
      const toastOptions = {};
      if (options !== null && options !== void 0 && options.durationMs) {
        toastOptions.toastLifeTimeMs = options.durationMs;
      }
      notifications.toasts.addSuccess({
        title,
        text: text ? toMountPoint(text, {
          theme$: theme.theme$
        }) : undefined
      }, toastOptions);
    }
  }, children);
};

/**
 * React hook for accessing pre-wired services.
 */
exports.UserProfilesKibanaProvider = UserProfilesKibanaProvider;
function useUserProfiles() {
  const context = (0, _react.useContext)(UserProfilesContext);
  if (!context) {
    throw new Error('UserProfilesContext is missing. Ensure your component or React root is wrapped with <UserProfilesProvider /> or <UserProfilesKibanaProvider />.');
  }
  return context;
}