"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateUserProfile = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _services = require("../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const i18nTexts = {
  notificationSuccess: {
    title: _i18n.i18n.translate('userProfileComponents.updateUserProfile.notification.submitSuccessTitle', {
      defaultMessage: 'Profile updated'
    }),
    pageReloadText: _i18n.i18n.translate('userProfileComponents.updateUserProfile.notification.requiresPageReloadDescription', {
      defaultMessage: 'One or more settings require you to reload the page to take effect.'
    })
  }
};
const useUpdateUserProfile = ({
  notificationSuccess = {},
  pageReloadChecker
} = {}) => {
  const {
    userProfileApiClient,
    notifySuccess
  } = (0, _services.useUserProfiles)();
  const {
    userProfile$
  } = userProfileApiClient;
  const {
    enabled: notificationSuccessEnabled = true,
    title: notificationTitle = i18nTexts.notificationSuccess.title,
    pageReloadText = i18nTexts.notificationSuccess.pageReloadText
  } = notificationSuccess;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const userProfileData = (0, _useObservable.default)(userProfile$);
  // Keep a snapshot before updating the user profile so we can compare previous and updated values
  const userProfileSnapshot = (0, _react.useRef)();
  const showSuccessNotification = (0, _react.useCallback)(({
    isRefreshRequired = false
  } = {}) => {
    if (isRefreshRequired) {
      notifySuccess({
        title: notificationTitle,
        text: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement("p", null, pageReloadText), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          onClick: () => window.location.reload(),
          "data-test-subj": "windowReloadButton"
        }, _i18n.i18n.translate('userProfileComponents.updateUserProfile.notification.requiresPageReloadButtonLabel', {
          defaultMessage: 'Reload page'
        }))))
      }, {
        durationMs: 1000 * 60 * 5
      });
    } else {
      notifySuccess({
        title: notificationTitle
      });
    }
  }, [notificationTitle, notifySuccess, pageReloadText]);
  const onUserProfileUpdate = (0, _react.useCallback)(updatedData => {
    setIsLoading(false);
    if (notificationSuccessEnabled) {
      const isRefreshRequired = pageReloadChecker === null || pageReloadChecker === void 0 ? void 0 : pageReloadChecker(userProfileSnapshot.current, updatedData);
      showSuccessNotification({
        isRefreshRequired
      });
    }
  }, [notificationSuccessEnabled, showSuccessNotification, pageReloadChecker]);
  const update = (0, _react.useCallback)(updatedData => {
    userProfileSnapshot.current = userProfileData;
    setIsLoading(true);
    return userProfileApiClient.update(updatedData).then(() => onUserProfileUpdate(updatedData));
  }, [userProfileApiClient, onUserProfileUpdate, userProfileData]);
  return {
    /** Update the user profile */
    update,
    /** Handler to show a notification after the user profile has been updated */
    showSuccessNotification,
    /** The current user profile data */
    userProfileData,
    /** Flag to indicate if currently updating */
    isLoading
  };
};
exports.useUpdateUserProfile = useUpdateUserProfile;