"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInteger = exports.createPostDynamicSettingsRoute = exports.createGetDynamicSettingsRoute = exports.DynamicSettingsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _saved_objects = require("../lib/saved_objects/saved_objects");
var _translations = require("../../../common/translations");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetDynamicSettingsRoute = _libs => ({
  method: 'GET',
  path: _constants.API_URLS.DYNAMIC_SETTINGS,
  validate: false,
  handler: async ({
    savedObjectsClient
  }) => {
    const dynamicSettingsAttributes = await _saved_objects.savedObjectsAdapter.getUptimeDynamicSettings(savedObjectsClient);
    return fromAttribute(dynamicSettingsAttributes);
  }
});
exports.createGetDynamicSettingsRoute = createGetDynamicSettingsRoute;
const validateInteger = value => {
  if (value % 1) {
    return _translations.VALUE_MUST_BE_AN_INTEGER;
  }
};
exports.validateInteger = validateInteger;
const DynamicSettingsSchema = _configSchema.schema.object({
  heartbeatIndices: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  certAgeThreshold: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    validate: validateInteger
  })),
  certExpirationThreshold: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    validate: validateInteger
  })),
  defaultConnectors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  defaultEmail: _configSchema.schema.maybe(_configSchema.schema.object({
    to: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    cc: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    bcc: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }))
});
exports.DynamicSettingsSchema = DynamicSettingsSchema;
const createPostDynamicSettingsRoute = _libs => ({
  method: 'PUT',
  path: _constants.API_URLS.DYNAMIC_SETTINGS,
  validate: {
    body: DynamicSettingsSchema
  },
  writeAccess: true,
  handler: async ({
    savedObjectsClient,
    request
  }) => {
    const newSettings = request.body;
    const prevSettings = await _saved_objects.savedObjectsAdapter.getUptimeDynamicSettings(savedObjectsClient);
    const attr = await _saved_objects.savedObjectsAdapter.setUptimeDynamicSettings(savedObjectsClient, {
      ...prevSettings,
      ...newSettings
    });
    return fromAttribute(attr);
  }
});
exports.createPostDynamicSettingsRoute = createPostDynamicSettingsRoute;
const fromAttribute = attr => {
  return {
    heartbeatIndices: attr.heartbeatIndices,
    certExpirationThreshold: attr.certExpirationThreshold,
    certAgeThreshold: attr.certAgeThreshold,
    defaultConnectors: attr.defaultConnectors,
    defaultEmail: attr.defaultEmail
  };
};