"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pingReducer = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  pingHistogram: null,
  loading: false,
  errors: []
};
const pingReducer = (0, _reduxActions.handleActions)({
  [String(_actions.getPingHistogram.get)]: state => ({
    ...state,
    loading: true
  }),
  [String(_actions.getPingHistogram.success)]: (state, action) => ({
    ...state,
    loading: false,
    pingHistogram: {
      ...action.payload
    }
  }),
  [String(_actions.getPingHistogram.fail)]: (state, action) => ({
    ...state,
    errors: [...state.errors, action.payload],
    loading: false
  })
}, initialState);
exports.pingReducer = pingReducer;