"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkEventsReducer = void 0;
var _reduxActions = require("redux-actions");
var _network_events = require("../actions/network_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {};
const networkEventsReducer = (0, _reduxActions.handleActions)({
  [String(_network_events.getNetworkEvents)]: (state, {
    payload: {
      checkGroup,
      stepIndex
    }
  }) => ({
    ...state,
    [checkGroup]: state[checkGroup] ? {
      [stepIndex]: state[checkGroup][stepIndex] ? {
        ...state[checkGroup][stepIndex],
        loading: true,
        events: [],
        total: 0,
        isWaterfallSupported: true
      } : {
        loading: true,
        events: [],
        total: 0,
        isWaterfallSupported: true
      }
    } : {
      [stepIndex]: {
        loading: true,
        events: [],
        total: 0,
        isWaterfallSupported: true
      }
    }
  }),
  [String(_network_events.getNetworkEventsSuccess)]: (state, {
    payload: {
      events,
      total,
      checkGroup,
      stepIndex,
      isWaterfallSupported,
      hasNavigationRequest
    }
  }) => {
    return {
      ...state,
      [checkGroup]: state[checkGroup] ? {
        [stepIndex]: state[checkGroup][stepIndex] ? {
          ...state[checkGroup][stepIndex],
          loading: false,
          events,
          total,
          isWaterfallSupported,
          hasNavigationRequest
        } : {
          loading: false,
          events,
          total,
          isWaterfallSupported,
          hasNavigationRequest
        }
      } : {
        [stepIndex]: {
          loading: false,
          events,
          total,
          isWaterfallSupported,
          hasNavigationRequest
        }
      }
    };
  },
  [String(_network_events.getNetworkEventsFail)]: (state, {
    payload: {
      checkGroup,
      stepIndex,
      error
    }
  }) => ({
    ...state,
    [checkGroup]: state[checkGroup] ? {
      [stepIndex]: state[checkGroup][stepIndex] ? {
        ...state[checkGroup][stepIndex],
        loading: false,
        events: [],
        total: 0,
        error,
        isWaterfallSupported: true
      } : {
        loading: false,
        events: [],
        total: 0,
        error,
        isWaterfallSupported: true
      }
    } : {
      [stepIndex]: {
        loading: false,
        events: [],
        total: 0,
        error,
        isWaterfallSupported: true
      }
    }
  })
}, initialState);
exports.networkEventsReducer = networkEventsReducer;