"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefineAlertConnectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../common/react_router_helpers");
var _constants = require("../../../../../../common/constants");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefineAlertConnectors = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(val => !val);
  const closePopover = () => setIsPopoverOpen(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: 'defineAlertSettingsSwitch',
      label: _translations.ENABLE_STATUS_ALERT,
      showLabel: false,
      "aria-label": _translations.ENABLE_STATUS_ALERT
      // this switch is read only, no onChange applied
      ,
      onChange: onButtonClick,
      checked: false,
      compressed: true,
      "data-test-subj": 'uptimeDisplayDefineConnector'
    }))),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: '350px'
    },
    "data-test-subj": 'uptimeSettingsDefineConnector'
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.ReactRouterEuiLink, {
    to: _constants.SETTINGS_ROUTE + '?focusConnectorField=true',
    "data-test-subj": 'uptimeSettingsLink'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.page_header.defineConnector.popover.defaultLink",
    defaultMessage: "Define a default connector"
  })), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.monitorList.defineConnector.popover.description",
    defaultMessage: "to receive status alerts."
  })));
};
exports.DefineAlertConnectors = DefineAlertConnectors;