"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTls = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_snap_shot = require("./use_snap_shot");
var _constants = require("../../../../../../common/constants");
var _alert_tls = require("../alert_tls");
var _selectors = require("../../../../state/selectors");
var _dynamic_settings = require("../../../../state/actions/dynamic_settings");
var _query_bar = require("../alert_query_bar/query_bar");
var _alert_monitor_status = require("../monitor_status_alert/alert_monitor_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertTls = ({
  id,
  stackVersion,
  ruleParams,
  setRuleParams
}) => {
  var _ruleParams$search, _ref, _ruleParams$certAgeTh, _ref2, _ruleParams$certExpir;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const {
    count,
    loading
  } = (0, _use_snap_shot.useSnapShotCount)({
    query: (_ruleParams$search = ruleParams.search) !== null && _ruleParams$search !== void 0 ? _ruleParams$search : ''
  });
  (0, _react.useEffect)(() => {
    if (!id && stackVersion && !ruleParams.stackVersion) {
      setRuleParams('stackVersion', stackVersion);
    }
  }, [ruleParams, id, stackVersion, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (typeof settings === 'undefined') {
      dispatch((0, _dynamic_settings.getDynamicSettings)());
    }
  }, [dispatch, settings]);
  const onSearchChange = (0, _react.useCallback)(value => {
    setRuleParams('search', value === '' ? undefined : value);
  }, [setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alert_monitor_status.AlertMonitorCount, {
    count: count.total,
    loading: loading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_query_bar.AlertQueryBar, {
    query: ruleParams.search || '',
    onChange: onSearchChange
  }), /*#__PURE__*/_react.default.createElement(_alert_tls.AlertTlsComponent, {
    ageThreshold: (_ref = (_ruleParams$certAgeTh = ruleParams.certAgeThreshold) !== null && _ruleParams$certAgeTh !== void 0 ? _ruleParams$certAgeTh : settings === null || settings === void 0 ? void 0 : settings.certAgeThreshold) !== null && _ref !== void 0 ? _ref : _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold,
    expirationThreshold: (_ref2 = (_ruleParams$certExpir = ruleParams.certExpirationThreshold) !== null && _ruleParams$certExpir !== void 0 ? _ruleParams$certExpir : settings === null || settings === void 0 ? void 0 : settings.certExpirationThreshold) !== null && _ref2 !== void 0 ? _ref2 : _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold,
    setAgeThreshold: value => setRuleParams('certAgeThreshold', Number(value)),
    setExpirationThreshold: value => setRuleParams('certExpirationThreshold', Number(value))
  }));
};
exports.AlertTls = AlertTls;