"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorBreadcrumb = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_breadcrumbs = require("../../../../hooks/use_breadcrumbs");
var _plugin = require("../../../../../../common/constants/plugin");
var _monitor_status_column = require("../../../overview/monitor_list/columns/monitor_status_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorBreadcrumb = ({
  details,
  activeStep,
  performanceBreakDownView = false
}) => {
  var _kibana$services$appl, _kibana$services$appl2, _activeStep$monitor, _details$journey, _details$journey$moni;
  const kibana = (0, _public.useKibana)();
  const appPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  (0, _use_breadcrumbs.useBreadcrumbs)([...(activeStep !== null && activeStep !== void 0 && activeStep.monitor ? [{
    text: (activeStep === null || activeStep === void 0 ? void 0 : (_activeStep$monitor = activeStep.monitor) === null || _activeStep$monitor === void 0 ? void 0 : _activeStep$monitor.name) || (activeStep === null || activeStep === void 0 ? void 0 : activeStep.monitor.id),
    href: `${appPath}/monitor/${btoa(activeStep === null || activeStep === void 0 ? void 0 : activeStep.monitor.id)}`
  }] : []), ...(details !== null && details !== void 0 && (_details$journey = details.journey) !== null && _details$journey !== void 0 && (_details$journey$moni = _details$journey.monitor) !== null && _details$journey$moni !== void 0 && _details$journey$moni.check_group ? [{
    text: (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(details === null || details === void 0 ? void 0 : details.timestamp)),
    href: `${appPath}/journey/${details.journey.monitor.check_group}/steps`
  }] : []), ...(performanceBreakDownView ? [{
    text: _i18n.i18n.translate('xpack.uptime.synthetics.performanceBreakDown.label', {
      defaultMessage: 'Performance breakdown'
    })
  }] : [])]);
};
exports.useMonitorBreadcrumb = useMonitorBreadcrumb;