"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationStatusTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _contexts = require("../../../../contexts");
var _constants = require("../../../../../../common/constants");
var _ = require("..");
var _monitor_status_column = require("../../../overview/monitor_list/columns/monitor_status_column");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Set height so that it remains within panel, enough height to display 7 locations tags
const TagContainer = _styledComponents.default.div`
  max-height: 246px;
  overflow: hidden;
`;
const LocationStatusTags = ({
  locations
}) => {
  var _moment$locale;
  const {
    colors: {
      gray,
      danger
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  const allLocations = [];
  const prevLocal = (_moment$locale = _moment.default.locale()) !== null && _moment$locale !== void 0 ? _moment$locale : 'en';
  const shortLocale = _moment.default.locale(_constants.SHORT_TS_LOCALE) === _constants.SHORT_TS_LOCALE;
  if (!shortLocale) {
    _moment.default.defineLocale(_constants.SHORT_TS_LOCALE, _constants.SHORT_TIMESPAN_LOCALE);
  }
  locations.forEach(item => {
    allLocations.push({
      label: item.geo.name,
      timestamp: (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(new Date(item.timestamp).valueOf())),
      color: item.summary.down === 0 ? gray : danger,
      availability: item.up_history / (item.up_history + item.down_history) * 100,
      status: item.summary.down === 0 ? 'up' : 'down'
    });
  });

  // Need to reset locale so it doesn't effect other parts of the app
  _moment.default.locale(prevLocal);

  // Sort lexicographically by label
  allLocations.sort((a, b) => {
    return a.label > b.label ? 1 : b.label > a.label ? -1 : 0;
  });
  if (allLocations.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TagContainer, null, /*#__PURE__*/_react.default.createElement(_.AvailabilityReporting, {
    allLocations: allLocations
  })));
};
exports.LocationStatusTags = LocationStatusTags;