"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationChartComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _charts = require("@elastic/charts");
var _reactRedux = require("react-redux");
var _helper = require("../../../lib/helper");
var _duration_line_series_list = require("./duration_line_series_list");
var _chart_wrapper = require("./chart_wrapper");
var _hooks = require("../../../hooks");
var _get_tick_format = require("./get_tick_format");
var _chart_empty_state = require("./chart_empty_state");
var _duration_line_bar_list = require("./duration_line_bar_list");
var _contexts = require("../../../contexts");
var _monitor = require("../../monitor");
var _selectors = require("../../../state/selectors");
var _formatting = require("../../../lib/formatting");
var _translations = require("../../../../../common/translations/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This chart is intended to visualize monitor duration performance over time to
 * the users in a helpful way. Its x-axis is based on a timeseries, the y-axis is in
 * milliseconds.
 * @param props The props required for this component to render properly
 */
const DurationChartComponent = ({
  locationDurationLines,
  anomalies,
  loading
}) => {
  var _monitor$monitor;
  const hasLines = locationDurationLines.length > 0;
  const [getUrlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    absoluteDateRangeStart: min,
    absoluteDateRangeEnd: max
  } = getUrlParams();
  const [hiddenLegends, setHiddenLegends] = (0, _react.useState)([]);
  const {
    chartTheme
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  const onBrushEnd = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [minX, maxX] = x;
    updateUrlParams({
      dateRangeStart: (0, _moment.default)(minX).toISOString(),
      dateRangeEnd: (0, _moment.default)(maxX).toISOString()
    });
  };
  const legendToggleVisibility = ([legendItem]) => {
    if (legendItem) {
      setHiddenLegends(prevState => {
        if (prevState.includes(legendItem.specId)) {
          return [...prevState.filter(item => item !== legendItem.specId)];
        } else {
          return [...prevState, legendItem.specId];
        }
      });
    }
  };
  const monitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  return /*#__PURE__*/_react.default.createElement(_chart_wrapper.ChartWrapper, {
    "aria-label": _i18n.i18n.translate('xpack.uptime.monitorCharts.durationChart.wrapper.label', {
      defaultMessage: `A chart displaying the monitor's ping duration, grouped by location.`
    }),
    height: _monitor.MONITOR_CHART_HEIGHT,
    loading: loading
  }, hasLines && typeof (monitor === null || monitor === void 0 ? void 0 : (_monitor$monitor = monitor.monitor) === null || _monitor$monitor === void 0 ? void 0 : _monitor$monitor.type) === 'string' ? /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    xDomain: {
      min,
      max
    },
    showLegend: true,
    showLegendExtra: true,
    legendPosition: _charts.Position.Right,
    onBrushEnd: onBrushEnd,
    onLegendItemClick: legendToggleVisibility,
    locale: _i18n.i18n.getLocale()
  }, chartTheme)), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: (0, _charts.timeFormatter)((0, _helper.getChartDateLabel)(min, max))
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    domain: {
      min: 0,
      max: NaN,
      fit: false
    },
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => (0, _get_tick_format.getTickFormat)(d),
    title: _i18n.i18n.translate('xpack.uptime.monitorCharts.durationChart.leftAxis.title', {
      defaultMessage: 'Duration in {unit}',
      values: {
        unit: monitor.monitor.type === 'browser' ? _translations.SECONDS_LABEL : _translations.MS_LABEL
      }
    }),
    labelFormat: d => (monitor === null || monitor === void 0 ? void 0 : monitor.monitor.type) === 'browser' ? `${(0, _formatting.microToSec)(d)}` : `${(0, _formatting.microToMilli)(d)}`
  }), /*#__PURE__*/_react.default.createElement(_duration_line_series_list.DurationLineSeriesList, {
    lines: locationDurationLines,
    monitorType: monitor.monitor.type
  }), /*#__PURE__*/_react.default.createElement(_duration_line_bar_list.DurationAnomaliesBar, {
    anomalies: anomalies,
    hiddenLegends: hiddenLegends
  })) : /*#__PURE__*/_react.default.createElement(_chart_empty_state.ChartEmptyState, {
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.durationChart.emptyPrompt.description",
      defaultMessage: "This monitor has never been {emphasizedText} during the selected time range.",
      values: {
        emphasizedText: /*#__PURE__*/_react.default.createElement("strong", null, "up")
      }
    }),
    title: _i18n.i18n.translate('xpack.uptime.durationChart.emptyPrompt.title', {
      defaultMessage: 'No duration data available'
    })
  }));
};
exports.DurationChartComponent = DurationChartComponent;