"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSettingsResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  deleteInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.deletingButtonLabel', {
    defaultMessage: 'Settings removal in progress…'
  }),
  deleteCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.deleteCompleteText', {
    defaultMessage: 'Deprecated settings removed'
  }),
  deleteFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.deleteFailedText', {
    defaultMessage: 'Settings removal failed'
  }),
  resolutionText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.resolutionText', {
    defaultMessage: 'Remove settings'
  }),
  resolutionTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.resolutionTooltipLabel', {
    defaultMessage: 'Resolve this issue by removing settings from this index. This issue can be resolved automatically.'
  })
};
const IndexSettingsResolutionCell = ({
  status
}) => {
  const {
    statusType
  } = status;
  if (statusType === 'in_progress') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "indexSettingsResolutionStatusCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18nTexts.deleteInProgressText)));
  }
  if (statusType === 'complete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "indexSettingsResolutionStatusCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: "success"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18nTexts.deleteCompleteText)));
  }
  if (statusType === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "indexSettingsResolutionStatusCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18nTexts.deleteFailedText)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18nTexts.resolutionTooltipLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "indexSettingsResolutionStatusCell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "indexSettings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18nTexts.resolutionText))));
};
exports.IndexSettingsResolutionCell = IndexSettingsResolutionCell;