"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationLoggingToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
require("./_deprecation_logging_toggle.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  fetchErrorMessage: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.fetchErrorMessage', {
    defaultMessage: 'Could not retrieve logging information.'
  }),
  reloadButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.reloadButtonLabel', {
    defaultMessage: 'Try again'
  }),
  updateErrorMessage: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.updateErrorMessage', {
    defaultMessage: 'Could not update logging state.'
  }),
  errorLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.errorLabel', {
    defaultMessage: 'Error'
  }),
  buttonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.buttonLabel', {
    defaultMessage: 'Enable deprecation log collection'
  }),
  loadingLogsLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.loadingLogsLabel', {
    defaultMessage: 'Loading deprecation log collection state…'
  })
};
const ErrorDetailsLink = ({
  error
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  if (!error.statusCode || !error.message) {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "danger",
    onClick: onButtonClick
  }, i18nTexts.errorLabel, " ", error.statusCode);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, error.message)));
};
const DeprecationLoggingToggle = ({
  isDeprecationLogIndexingEnabled,
  isLoading,
  isUpdating,
  fetchError,
  updateError,
  resendRequest,
  toggleLogging
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      className: "upgToggleLoading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "upgLoadingItem"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, i18nTexts.loadingLogsLabel));
  }
  if (fetchError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "flexEnd",
      "data-test-subj": "fetchLoggingError"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, i18nTexts.fetchErrorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(ErrorDetailsLink, {
      error: fetchError
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "refresh",
      onClick: resendRequest
    }, i18nTexts.reloadButtonLabel)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "deprecationLoggingToggle",
    label: i18nTexts.buttonLabel,
    checked: !!isDeprecationLogIndexingEnabled,
    onChange: toggleLogging,
    disabled: Boolean(fetchError) || isUpdating
  })), updateError && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd",
    "data-test-subj": "updateLoggingError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger"
  }, i18nTexts.updateErrorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ErrorDetailsLink, {
    error: updateError
  })))), isUpdating && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })));
};
exports.DeprecationLoggingToggle = DeprecationLoggingToggle;