"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.QueryLanguageSwitcher = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getSwitchLanguageButtonText: () => _i18n.i18n.translate('unifiedSearch.switchLanguage.buttonText', {
    defaultMessage: 'Switch language button.'
  })
};
exports.strings = strings;
const QueryLanguageSwitcher = /*#__PURE__*/_react.default.memo(function QueryLanguageSwitcher({
  language,
  anchorPosition,
  onSelectLanguage,
  nonKqlMode = 'lucene',
  isOnTopBarMenu,
  isDisabled,
  deps: {
    docLinks
  }
}) {
  const kueryQuerySyntaxDocs = docLinks.links.query.kueryQuerySyntax;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "m",
    iconType: "filter",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    className: "euiFormControlLayout__append kqlQueryBar__languageSwitcherButton",
    "data-test-subj": 'switchQueryLanguageButton',
    "aria-label": strings.getSwitchLanguageButtonText(),
    disabled: isDisabled
  });
  const languageMenuItem = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "KQL",
    icon: language === 'kuery' ? 'check' : 'empty',
    "data-test-subj": "kqlLanguageMenuItem",
    onClick: () => {
      onSelectLanguage('kuery');
    }
  }, "KQL"), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: nonKqlMode,
    icon: language === 'kuery' ? 'empty' : 'check',
    "data-test-subj": "luceneLanguageMenuItem",
    onClick: () => {
      onSelectLanguage(nonKqlMode);
    }
  }, (0, _eui.toSentenceCase)(nonKqlMode)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: 'documentation',
    icon: 'documentation',
    href: kueryQuerySyntaxDocs,
    target: "_blank"
  }, "Documentation"));
  const languageQueryStringComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "queryLanguageSwitcherPopover",
    anchorPosition: anchorPosition || 'downLeft',
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    repositionOnScroll: true,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedSearch.query.queryBar.syntaxOptionsTitle",
    defaultMessage: "Syntax options"
  })), languageMenuItem);
  return Boolean(isOnTopBarMenu) ? languageMenuItem : languageQueryStringComponent;
});
exports.QueryLanguageSwitcher = QueryLanguageSwitcher;