"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterEditorWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _filter_item = require("../filter_bar/filter_item/filter_item");
var _filter_editor = require("../filter_bar/filter_editor");
var _fetch_index_patterns = require("./fetch_index_patterns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FilterEditorWrapper = /*#__PURE__*/_react.default.memo(function FilterEditorWrapper({
  indexPatterns,
  filters,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  closePopoverOnAdd,
  closePopoverOnCancel,
  onFiltersUpdated,
  onLocalFilterUpdate,
  onLocalFilterCreate,
  suggestionsAbstraction
}) {
  const fetchIndexAbortController = (0, _react.useRef)();
  const kibana = (0, _public.useKibana)();
  const {
    uiSettings,
    data,
    usageCollection,
    appName,
    docLinks
  } = kibana.services;
  const reportUiCounter = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, appName);
  const [dataViews, setDataviews] = (0, _react.useState)([]);
  const [newFilter, setNewFilter] = (0, _react.useState)(undefined);
  const isPinned = uiSettings.get(_common.UI_SETTINGS.FILTERS_PINNED_BY_DEFAULT);
  (0, _react.useEffect)(() => {
    fetchIndexAbortController.current = new AbortController();
    return () => {
      var _fetchIndexAbortContr;
      (_fetchIndexAbortContr = fetchIndexAbortController.current) === null || _fetchIndexAbortContr === void 0 ? void 0 : _fetchIndexAbortContr.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    const fetchDataViews = async () => {
      var _fetchIndexAbortContr2;
      const stringPatterns = indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns.filter(indexPattern => typeof indexPattern === 'string');
      const objectPatterns = indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns.filter(indexPattern => typeof indexPattern !== 'string');
      (_fetchIndexAbortContr2 = fetchIndexAbortController.current) === null || _fetchIndexAbortContr2 === void 0 ? void 0 : _fetchIndexAbortContr2.abort();
      fetchIndexAbortController.current = new AbortController();
      const currentFetchIndexAbortController = fetchIndexAbortController.current;
      const objectPatternsFromStrings = await (0, _fetch_index_patterns.fetchIndexPatterns)(data.dataViews, stringPatterns.map(value => ({
        type: 'title',
        value
      })));
      if (!currentFetchIndexAbortController.signal.aborted) {
        setDataviews([...objectPatterns, ...objectPatternsFromStrings]);
        const [dataView] = [...objectPatterns, ...objectPatternsFromStrings];
        const index = dataView && dataView.id;
        const emptyFilter = (0, _esQuery.buildEmptyFilter)(isPinned, index);
        setNewFilter(emptyFilter);
      }
    };
    if (indexPatterns) {
      fetchDataViews();
    }
  }, [data.dataViews, indexPatterns, onLocalFilterCreate, onLocalFilterUpdate, isPinned]);
  function onAdd(filter) {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:added`);
    closePopoverOnAdd === null || closePopoverOnAdd === void 0 ? void 0 : closePopoverOnAdd();
    const updatedFilters = [...filters, filter];
    onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(updatedFilters);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: _filter_item.FILTER_EDITOR_WIDTH,
      maxWidth: '100%'
    }
  }, newFilter && /*#__PURE__*/_react.default.createElement(_filter_editor.FilterEditor, {
    mode: "add",
    filter: newFilter,
    indexPatterns: dataViews,
    key: JSON.stringify(newFilter),
    onSubmit: onAdd,
    onCancel: () => closePopoverOnCancel === null || closePopoverOnCancel === void 0 ? void 0 : closePopoverOnCancel(),
    onLocalFilterUpdate: onLocalFilterUpdate,
    onLocalFilterCreate: onLocalFilterCreate,
    timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
    filtersForSuggestions: filtersForSuggestions,
    suggestionsAbstraction: suggestionsAbstraction,
    docLinks: docLinks
  }));
});
exports.FilterEditorWrapper = FilterEditorWrapper;