"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.FilterEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _css = require("@emotion/css");
var _generic_combo_box = require("./generic_combo_box");
var _filter_editor_utils = require("./lib/filter_editor_utils");
var _filters_builder = require("../../filters_builder");
var _filter_badge_group = require("../../filter_badge/filter_badge_group");
var _helpers = require("./lib/helpers");
var _filter_editor = require("./filter_editor.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getPanelTitleAdd: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.addFilterPopupTitle', {
    defaultMessage: 'Add filter'
  }),
  getPanelTitleEdit: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.editFilterPopupTitle', {
    defaultMessage: 'Edit filter'
  }),
  getAddButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.addButtonLabel', {
    defaultMessage: 'Add filter'
  }),
  getUpdateButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.updateButtonLabel', {
    defaultMessage: 'Update filter'
  }),
  getSelectDataViewToolTip: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.chooseDataViewFirstToolTip', {
    defaultMessage: 'You need to select a data view first'
  }),
  getCustomLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.createCustomLabelInputLabel', {
    defaultMessage: 'Custom label (optional)'
  }),
  getAddCustomLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.customLabelPlaceholder', {
    defaultMessage: 'Add a custom label here'
  }),
  getSelectDataView: () => _i18n.i18n.translate('unifiedSearch.filter.filterBar.indexPatternSelectPlaceholder', {
    defaultMessage: 'Select a data view'
  }),
  getDataView: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.dateViewSelectLabel', {
    defaultMessage: 'Data view'
  }),
  getQueryDslLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.queryDslLabel', {
    defaultMessage: 'Elasticsearch Query DSL'
  }),
  getQueryDslDocsLinkLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.queryDslDocsLinkLabel', {
    defaultMessage: 'Learn about Query DSL syntax'
  }),
  getQueryDslAriaLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.queryDslAriaLabel', {
    defaultMessage: 'Elasticsearch Query DSL editor'
  }),
  getSpatialFilterQueryDslHelpText: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.spatialFilterQueryDslHelpText', {
    defaultMessage: 'Editing Elasticsearch Query DSL prevents filter geometry from displaying in map.'
  })
};
exports.strings = strings;
class FilterEditorComponent extends _react.Component {
  constructor(props) {
    var _this$props$filter2;
    super(props);
    (0, _defineProperty2.default)(this, "toggleCustomEditor", () => {
      const isCustomEditorOpen = !this.state.isCustomEditorOpen;
      this.setState({
        isCustomEditorOpen
      });
      if (this.props.onLocalFilterUpdate) {
        const {
          customLabel,
          queryDsl,
          localFilter
        } = this.state;
        if (isCustomEditorOpen) {
          this.props.onLocalFilterUpdate({
            queryDsl,
            customLabel
          });
        } else {
          this.props.onLocalFilterUpdate(localFilter);
        }
      }
    });
    (0, _defineProperty2.default)(this, "isQueryDslValid", queryDsl => {
      try {
        const queryDslJson = JSON.parse(queryDsl);
        return Object.keys(queryDslJson).length > 0;
      } catch {
        return false;
      }
    });
    (0, _defineProperty2.default)(this, "onIndexPatternChange", ([selectedDataView]) => {
      this.setState({
        selectedDataView,
        localFilter: (0, _esQuery.buildEmptyFilter)(false, selectedDataView.id)
      });
    });
    (0, _defineProperty2.default)(this, "onCustomLabelChange", event => {
      const customLabel = event.target.value;
      this.setState({
        customLabel
      });
      if (this.props.onLocalFilterUpdate) {
        if (this.state.isCustomEditorOpen) {
          const {
            queryDsl
          } = this.state;
          this.props.onLocalFilterUpdate({
            queryDsl,
            customLabel
          });
        } else {
          const localFilter = {
            ...this.state.localFilter,
            meta: {
              ...this.state.localFilter.meta,
              alias: customLabel || null
            }
          };
          this.props.onLocalFilterUpdate(localFilter);
        }
      }
    });
    (0, _defineProperty2.default)(this, "onQueryDslChange", queryDsl => {
      this.setState({
        queryDsl
      });
      if (this.props.onLocalFilterUpdate) {
        const {
          customLabel
        } = this.state;
        this.props.onLocalFilterUpdate({
          queryDsl,
          customLabel
        });
      }
    });
    (0, _defineProperty2.default)(this, "getFilterFromQueryDsl", queryDsl => {
      const {
        customLabel
      } = this.state;
      const {
        $state,
        meta: {
          index,
          disabled = false,
          negate = false
        }
      } = this.props.filter;
      if (!$state || !$state.store) {
        return;
      }
      const newIndex = index || this.props.indexPatterns[0].id;
      try {
        const body = JSON.parse(queryDsl);
        return (0, _esQuery.buildCustomFilter)(newIndex, body, disabled, negate, customLabel || null, $state.store);
      } catch {
        return null;
      }
    });
    (0, _defineProperty2.default)(this, "onLocalFilterChange", updatedFilters => {
      var _this$props$onLocalFi, _this$props;
      const {
        selectedDataView,
        customLabel
      } = this.state;
      const alias = customLabel || null;
      const {
        $state,
        meta: {
          disabled = false
        }
      } = this.props.filter;
      if (!$state || !$state.store || !selectedDataView) {
        return;
      }
      let newFilter;
      if (updatedFilters.length === 1) {
        const f = updatedFilters[0];
        newFilter = {
          ...f,
          $state: {
            store: $state.store
          },
          meta: {
            ...f.meta,
            disabled,
            alias
          }
        };
      } else {
        // for the combined filters created on the builder, negate should always be false,
        // the global negation changes only from the exclude/inclue results panel item
        newFilter = (0, _esQuery.buildCombinedFilter)(_esQuery.BooleanRelation.AND, updatedFilters, selectedDataView, disabled, false, alias, $state.store);
      }
      this.setState({
        localFilter: newFilter
      });
      (_this$props$onLocalFi = (_this$props = this.props).onLocalFilterUpdate) === null || _this$props$onLocalFi === void 0 ? void 0 : _this$props$onLocalFi.call(_this$props, newFilter);
    });
    (0, _defineProperty2.default)(this, "onSubmit", () => {
      const {
        isCustomEditorOpen,
        queryDsl,
        customLabel
      } = this.state;
      const {
        $state
      } = this.props.filter;
      if (!$state || !$state.store) {
        return;
      }
      if (isCustomEditorOpen) {
        var _this$props$filter, _this$props$filter$me;
        const filter = ((_this$props$filter = this.props.filter) === null || _this$props$filter === void 0 ? void 0 : _this$props$filter.meta.type) === _esQuery.FILTERS.CUSTOM ||
        // only convert non-custom filters to custom when DSL changes
        queryDsl !== this.parseFilterToQueryDsl(this.props.filter) ? this.getFilterFromQueryDsl(queryDsl) : {
          ...this.props.filter,
          meta: {
            ...((_this$props$filter$me = this.props.filter.meta) !== null && _this$props$filter$me !== void 0 ? _this$props$filter$me : {}),
            alias: customLabel || null
          }
        };
        if (!filter) {
          return;
        }
        this.props.onSubmit(filter);
      } else {
        const localFilter = {
          ...this.state.localFilter,
          meta: {
            ...this.state.localFilter.meta,
            alias: customLabel || null
          }
        };
        this.props.onSubmit(localFilter);
      }
    });
    const dataView = this.getIndexPatternFromFilter();
    this.state = {
      selectedDataView: dataView,
      customLabel: props.filter.meta.alias || '',
      queryDsl: this.parseFilterToQueryDsl(props.filter),
      isCustomEditorOpen: this.isUnknownFilterType() || !!((_this$props$filter2 = this.props.filter) !== null && _this$props$filter2 !== void 0 && _this$props$filter2.meta.isMultiIndex),
      localFilter: dataView ? (0, _lodash.merge)({}, props.filter) : (0, _esQuery.buildEmptyFilter)(false)
    };
  }
  componentDidMount() {
    var _this$props$onLocalFi2, _this$props2, _this$props$onLocalFi3, _this$props3;
    const {
      localFilter,
      queryDsl,
      customLabel
    } = this.state;
    (_this$props$onLocalFi2 = (_this$props2 = this.props).onLocalFilterCreate) === null || _this$props$onLocalFi2 === void 0 ? void 0 : _this$props$onLocalFi2.call(_this$props2, {
      filter: localFilter,
      queryDslFilter: {
        queryDsl,
        customLabel
      }
    });
    (_this$props$onLocalFi3 = (_this$props3 = this.props).onLocalFilterUpdate) === null || _this$props$onLocalFi3 === void 0 ? void 0 : _this$props$onLocalFi3.call(_this$props3, localFilter);
  }
  parseFilterToQueryDsl(filter) {
    const dsl = (0, _esQuery.filterToQueryDsl)(filter, this.props.indexPatterns);
    return JSON.stringify(dsl, null, 2);
  }
  render() {
    var _this$props$filter3;
    const toggleEditorFlexItem = (_this$props$filter3 = this.props.filter) !== null && _this$props$filter3 !== void 0 && _this$props$filter3.meta.isMultiIndex ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "editQueryDSL",
      onClick: this.toggleCustomEditor
    }, this.state.isCustomEditorOpen ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.filterEditor.editFilterValuesButtonLabel",
      defaultMessage: "Edit filter values"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.filterEditor.editQueryDslButtonLabel",
      defaultMessage: "Edit as Query DSL"
    })));
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, this.props.mode === 'add' ? strings.getPanelTitleAdd() : strings.getPanelTitleEdit(), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('unifiedSearch.filter.filterEditor.experimentalLabel', {
      defaultMessage: 'Technical preview'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "filterEditor__hiddenItem"
    }), toggleEditorFlexItem)), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "globalFilterItem__editorForm"
    }, this.renderIndexPatternInput(), this.state.isCustomEditorOpen ? this.renderCustomEditor() : this.renderFiltersBuilderEditor(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: strings.getCustomLabel(),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: `${this.state.customLabel}`,
      onChange: this.onCustomLabelChange,
      placeholder: strings.getAddCustomLabel(),
      fullWidth: true
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "rowReverse",
      alignItems: "center",
      style: {
        isolation: 'isolate'
      },
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.onSubmit,
      isDisabled: !this.isFilterValid(),
      "data-test-subj": "saveFilter"
    }, this.props.mode === 'add' ? strings.getAddButtonLabel() : strings.getUpdateButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "right",
      onClick: this.props.onCancel,
      "data-test-subj": "cancelSaveFilter"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.filterEditor.cancelButtonLabel",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)))));
  }
  renderIndexPatternInput() {
    var _this$props$filter4;
    if ((_this$props$filter4 = this.props.filter) !== null && _this$props$filter4 !== void 0 && _this$props$filter4.meta.isMultiIndex) {
      // Don't render index pattern selector if filter supports multiple index patterns
      return null;
    }
    if (this.props.indexPatterns.length <= 1 && this.props.indexPatterns.find(indexPattern => indexPattern === this.getIndexPatternFromFilter())) {
      /**
       * Don't render the index pattern selector if there's just one \ zero index patterns
       * and if the index pattern the filter was LOADED with is in the indexPatterns list.
       **/

      return null;
    }
    const {
      selectedDataView
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: strings.getDataView()
    }, /*#__PURE__*/_react.default.createElement(_generic_combo_box.GenericComboBox, {
      fullWidth: true,
      placeholder: strings.getSelectDataView(),
      options: this.props.indexPatterns,
      selectedOptions: selectedDataView ? [selectedDataView] : [],
      getLabel: indexPattern => indexPattern.getName(),
      onChange: this.onIndexPatternChange,
      isClearable: false,
      "data-test-subj": "filterIndexPatternsSelect",
      singleSelection: _helpers.SINGLE_SELECTION_AS_TEXT_PROPS,
      truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  hasCombinedFilterCustomType(filters) {
    return filters.some(filter => filter.meta.type === 'custom');
  }
  renderFiltersBuilderEditor() {
    const {
      selectedDataView,
      localFilter
    } = this.state;
    const flattenedFilters = (0, _helpers.flattenFilters)([localFilter]);
    const shouldShowPreview = selectedDataView && (flattenedFilters.length > 1 && !this.hasCombinedFilterCustomType(flattenedFilters) || flattenedFilters.length === 1 && (0, _filter_editor_utils.isFilterValid)(selectedDataView, (0, _filter_editor_utils.getFieldFromFilter)(flattenedFilters[0], selectedDataView), (0, _filter_editor_utils.getOperatorFromFilter)(flattenedFilters[0]), (0, _esQuery.getFilterParams)(flattenedFilters[0])));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      role: "region",
      "aria-label": "",
      className: (0, _css.cx)((0, _filter_editor.filtersBuilderMaxHeightCss)(this.props.theme.euiTheme), 'eui-yScroll')
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: selectedDataView ? '' : strings.getSelectDataViewToolTip(),
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_filters_builder.FiltersBuilder, {
      filters: [localFilter],
      timeRangeForSuggestionsOverride: this.props.timeRangeForSuggestionsOverride,
      filtersForSuggestions: this.props.filtersForSuggestions,
      dataView: selectedDataView,
      onChange: this.onLocalFilterChange,
      disabled: !selectedDataView,
      suggestionsAbstraction: this.props.suggestionsAbstraction,
      filtersCount: this.props.filtersCount
    }))), shouldShowPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      hasEmptyLabelSpace: true,
      className: (0, _css.cx)(_filter_editor.filterBadgeStyle, _filter_editor.filterPreviewLabelStyle),
      label: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "unifiedSearch.filter.filterBar.preview",
        defaultMessage: "{icon} Preview",
        values: {
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "inspect",
            size: "s"
          })
        }
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": "filter-preview",
      css: {
        overflowWrap: 'break-word'
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_badge_group.FilterBadgeGroup, {
      filters: [localFilter],
      dataViews: this.props.indexPatterns,
      booleanRelation: _esQuery.BooleanRelation.AND,
      shouldShowBrackets: false
    }))) : null);
  }
  renderCustomEditor() {
    var _this$props$filter5;
    let helpText = '';
    if (this.props.docLinks) {
      helpText = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: this.props.docLinks.links.query.queryDsl,
        target: "_blank"
      }, strings.getQueryDslDocsLinkLabel());
    }
    if (((_this$props$filter5 = this.props.filter) === null || _this$props$filter5 === void 0 ? void 0 : _this$props$filter5.meta.type) === _esQuery.FILTERS.SPATIAL_FILTER) {
      helpText = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "warning"
      }, strings.getSpatialFilterQueryDslHelpText());
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: strings.getQueryDslLabel(),
      helpText: helpText
    }, /*#__PURE__*/_react.default.createElement(_public2.CodeEditor, {
      languageId: _monaco.XJsonLang.ID,
      width: "100%",
      height: '250px',
      value: this.state.queryDsl,
      onChange: this.onQueryDslChange,
      "data-test-subj": "customEditorInput",
      "aria-label": strings.getQueryDslAriaLabel()
    }));
  }
  isUnknownFilterType() {
    const {
      type
    } = this.props.filter.meta;
    if ((0, _esQuery.isCombinedFilter)(this.props.filter)) {
      const {
        params
      } = this.props.filter.meta;
      return params && this.hasCombinedFilterCustomType(params);
    }
    return !!type && !['phrase', 'phrases', 'range', 'exists', 'combined'].includes(type);
  }
  getIndexPatternFromFilter() {
    return (0, _public.getIndexPatternFromFilter)(this.props.filter, this.props.indexPatterns);
  }
  isFilterValid() {
    const {
      isCustomEditorOpen,
      queryDsl,
      selectedDataView,
      localFilter
    } = this.state;
    if (isCustomEditorOpen) {
      return this.isQueryDslValid(queryDsl);
    }
    if (!selectedDataView) {
      return false;
    }
    return (0, _helpers.flattenFilters)([localFilter]).every(f => (0, _filter_editor_utils.isFilterValid)(selectedDataView, (0, _filter_editor_utils.getFieldFromFilter)(f, selectedDataView), (0, _filter_editor_utils.getOperatorFromFilter)(f), (0, _esQuery.getFilterParams)(f)));
  }
}
const FilterEditor = (0, _eui.withEuiTheme)(FilterEditorComponent);
exports.FilterEditor = FilterEditor;