"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _filter_badge = require("../filter_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
class ApplyFiltersPopoverContent extends _react2.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getLabel", filter => {
      const valueLabel = (0, _public.getDisplayValueFromFilter)(filter, this.props.indexPatterns);
      const fieldLabel = (0, _public.getFieldDisplayValueFromFilter)(filter, this.props.indexPatterns);
      return /*#__PURE__*/_react2.default.createElement(_filter_badge.FilterContent, {
        filter: filter,
        valueLabel: valueLabel,
        fieldLabel: fieldLabel
      });
    });
    (0, _defineProperty2.default)(this, "isFilterSelected", i => {
      return this.state.isFilterSelected[i];
    });
    (0, _defineProperty2.default)(this, "toggleFilterSelected", i => {
      const isFilterSelected = [...this.state.isFilterSelected];
      isFilterSelected[i] = !isFilterSelected[i];
      this.setState({
        isFilterSelected
      });
    });
    (0, _defineProperty2.default)(this, "onSubmit", () => {
      const selectedFilters = this.props.filters.filter((filter, i) => this.state.isFilterSelected[i]);
      this.props.onSubmit(selectedFilters);
    });
    this.state = {
      isFilterSelected: props.filters.map(() => true),
      fieldLabel: undefined
    };
  }
  render() {
    if (this.props.filters.length === 0) {
      return '';
    }
    const mappedFilters = (0, _public.mapAndFlattenFilters)(this.props.filters);
    const form = /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, mappedFilters.map((filter, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
      key: i
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCheckbox, {
      id: `filterCheckbox-${i}`,
      label: this.getLabel(filter),
      checked: this.isFilterSelected(i),
      onChange: () => this.toggleFilterSelected(i),
      css: (0, _react.css)`
                word-break: break-word;
              `
    }))));
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.applyFilters.popupHeader",
      defaultMessage: "Select filters to apply"
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, null, form), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.props.onCancel
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.applyFiltersPopup.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: this.onSubmit,
      "data-test-subj": "applyFiltersPopoverButton",
      fill: true
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.filter.applyFiltersPopup.saveButtonLabel",
      defaultMessage: "Apply"
    }))));
  }
}
exports.default = ApplyFiltersPopoverContent;
(0, _defineProperty2.default)(ApplyFiltersPopoverContent, "defaultProps", {
  filters: []
});
module.exports = exports.default;