"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setUnifiedDocViewerServices = exports.getUnifiedDocViewerServices = exports.UnifiedDocViewerPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const [getUnifiedDocViewerServices, setUnifiedDocViewerServices] = (0, _public.createGetterSetter)('UnifiedDocViewerServices');
exports.setUnifiedDocViewerServices = setUnifiedDocViewerServices;
exports.getUnifiedDocViewerServices = getUnifiedDocViewerServices;
const DocViewerLegacyTable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_table/legacy'))));
const DocViewerTable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_table'))));
const SourceViewer = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_source'))));
class UnifiedDocViewerPublicPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "docViewsRegistry", new _unifiedDocViewer.DocViewsRegistry());
  }
  setup(core) {
    this.docViewsRegistry.addDocView({
      title: _i18n.i18n.translate('unifiedDocViewer.docViews.table.tableTitle', {
        defaultMessage: 'Table'
      }),
      order: 10,
      component: props => {
        const {
          uiSettings
        } = getUnifiedDocViewerServices();
        const DocView = uiSettings.get(_discoverUtils.DOC_TABLE_LEGACY) ? DocViewerLegacyTable : DocViewerTable;
        return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
            delay: 300
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null))
        }, /*#__PURE__*/_react.default.createElement(DocView, props));
      }
    });
    this.docViewsRegistry.addDocView({
      title: _i18n.i18n.translate('unifiedDocViewer.docViews.json.jsonTitle', {
        defaultMessage: 'JSON'
      }),
      order: 20,
      component: ({
        hit,
        dataView,
        query,
        textBasedHits
      }) => {
        var _hit$raw$_id;
        return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
            delay: 300
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null))
        }, /*#__PURE__*/_react.default.createElement(SourceViewer, {
          index: hit.raw._index,
          id: (_hit$raw$_id = hit.raw._id) !== null && _hit$raw$_id !== void 0 ? _hit$raw$_id : hit.id,
          dataView: dataView,
          textBasedHits: textBasedHits,
          hasLineNumbers: true,
          onRefresh: () => {}
        }));
      }
    });
    return {
      addDocView: this.docViewsRegistry.addDocView.bind(this.docViewsRegistry)
    };
  }
  start(core, deps) {
    const {
      analytics,
      uiSettings
    } = core;
    const {
      data,
      fieldFormats
    } = deps;
    const storage = new _public.Storage(localStorage);
    const unifiedDocViewer = {
      getDocViews: this.docViewsRegistry.getDocViewsSorted.bind(this.docViewsRegistry)
    };
    const services = {
      analytics,
      data,
      fieldFormats,
      storage,
      uiSettings,
      unifiedDocViewer
    };
    setUnifiedDocViewerServices(services);
    return unifiedDocViewer;
  }
}
exports.UnifiedDocViewerPublicPlugin = UnifiedDocViewerPublicPlugin;