"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariablePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VariablePopover = ({
  variables,
  onSelect,
  variablesHelpLink
}) => {
  const [isVariablesPopoverOpen, setIsVariablesPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsVariablesPopoverOpen(false);
  const options = variables.map(({
    label
  }) => ({
    key: label,
    label
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => setIsVariablesPopoverOpen(true)
    }, _i18n.txtAddVariableButtonTitle, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "indexOpen"
    }))),
    isOpen: isVariablesPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    searchable: true,
    searchProps: {
      placeholder: _i18n.txtUrlTemplateVariablesFilterPlaceholderText,
      compressed: true
    },
    options: options,
    onChange: newOptions => {
      const selected = newOptions.find(o => o.checked === 'on');
      if (!selected) return;
      onSelect(selected.key);
      closePopover();
    },
    listProps: {
      showIcons: false
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 320
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, search), list, variablesHelpLink && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    className: 'eui-textRight'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: variablesHelpLink,
    target: "_blank"
  }, _i18n.txtUrlTemplateVariablesHelpLinkText)))));
};
exports.VariablePopover = VariablePopover;