"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleSnoozeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _snooze = require("../../../lib/rule_api/snooze");
var _unsnooze = require("../../../lib/rule_api/unsnooze");
var _notify_badge = require("./notify_badge");
var _rule_snooze = require("./rule_snooze");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isRuleSnoozed = rule => Boolean(rule.isSnoozedUntil && new Date(rule.isSnoozedUntil).getTime() > Date.now() || rule.muteAll);
const RuleSnoozeModal = ({
  rule,
  onClose,
  onLoading,
  onRuleChanged
}) => {
  var _rule$activeSnoozes, _rule$snoozeSchedule;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const isSnoozed = (0, _react.useMemo)(() => {
    return isRuleSnoozed(rule);
  }, [rule]);
  const onApplySnooze = (0, _react.useCallback)(async snoozeSchedule => {
    try {
      onLoading(true);
      onClose();
      await (0, _snooze.snoozeRule)({
        http,
        id: rule.id,
        snoozeSchedule
      });
      onRuleChanged();
      toasts.addSuccess(_notify_badge.SNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
    }
  }, [onLoading, onClose, http, rule.id, onRuleChanged, toasts]);
  const onApplyUnsnooze = (0, _react.useCallback)(async scheduleIds => {
    try {
      onLoading(true);
      onClose();
      await (0, _unsnooze.unsnoozeRule)({
        http,
        id: rule.id,
        scheduleIds
      });
      onRuleChanged();
      toasts.addSuccess(_notify_badge.UNSNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
    }
  }, [onLoading, onClose, http, rule.id, onRuleChanged, toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "ruleSnoozeModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
    inPopover: false,
    interval: (0, _rule_snooze.futureTimeToInterval)(rule.isSnoozedUntil),
    activeSnoozes: (_rule$activeSnoozes = rule.activeSnoozes) !== null && _rule$activeSnoozes !== void 0 ? _rule$activeSnoozes : [],
    scheduledSnoozes: (_rule$snoozeSchedule = rule.snoozeSchedule) !== null && _rule$snoozeSchedule !== void 0 ? _rule$snoozeSchedule : [],
    showCancel: isSnoozed,
    snoozeRule: onApplySnooze,
    unsnoozeRule: onApplyUnsnooze
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleSnoozeModal = RuleSnoozeModal;