"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALID_CONSUMERS = exports.RuleFormConsumerSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECT_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.selectLabel', {
  defaultMessage: 'Role visibility'
});
const featureNameMap = {
  [_ruleDataUtils.AlertConsumers.LOGS]: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.logs', {
    defaultMessage: 'Logs'
  }),
  [_ruleDataUtils.AlertConsumers.INFRASTRUCTURE]: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.infrastructure', {
    defaultMessage: 'Metrics'
  }),
  [_ruleDataUtils.AlertConsumers.APM]: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.apm', {
    defaultMessage: 'APM and User Experience'
  }),
  [_ruleDataUtils.AlertConsumers.UPTIME]: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.uptime', {
    defaultMessage: 'Synthetics and Uptime'
  }),
  [_ruleDataUtils.AlertConsumers.SLO]: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.slo', {
    defaultMessage: 'SLOs'
  }),
  stackAlerts: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.stackAlerts', {
    defaultMessage: 'Stack Rules'
  })
};
const VALID_CONSUMERS = [_ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE, 'stackAlerts'];
exports.VALID_CONSUMERS = VALID_CONSUMERS;
const SINGLE_SELECTION = {
  asPlainText: true
};
const RuleFormConsumerSelection = props => {
  var _errors$consumer, _errors$consumer2;
  const {
    consumers,
    errors,
    onChange,
    selectedConsumer,
    initialSelectedConsumer
  } = props;
  const isInvalid = (errors === null || errors === void 0 ? void 0 : (_errors$consumer = errors.consumer) === null || _errors$consumer === void 0 ? void 0 : _errors$consumer.length) > 0;
  const handleOnChange = (0, _react.useCallback)(selected => {
    if (selected.length > 0) {
      const newSelectedConsumer = selected[0];
      onChange(newSelectedConsumer.value);
    } else {
      onChange(null);
    }
  }, [onChange]);
  const validatedSelectedConsumer = (0, _react.useMemo)(() => {
    if (selectedConsumer && consumers.includes(selectedConsumer) && featureNameMap[selectedConsumer]) {
      return selectedConsumer;
    }
    return null;
  }, [selectedConsumer, consumers]);
  const selectedOptions = (0, _react.useMemo)(() => validatedSelectedConsumer ? [{
    value: validatedSelectedConsumer,
    label: featureNameMap[validatedSelectedConsumer]
  }] : [], [validatedSelectedConsumer]);
  const formattedSelectOptions = (0, _react.useMemo)(() => {
    return consumers.reduce((result, consumer) => {
      if (featureNameMap[consumer]) {
        result.push({
          value: consumer,
          'data-test-subj': consumer,
          label: featureNameMap[consumer]
        });
      }
      return result;
    }, []).sort((a, b) => {
      return a.value.localeCompare(b.value);
    });
  }, [consumers]);
  (0, _react.useEffect)(() => {
    // At initialization, select initialSelectedConsumer or the first value
    if (!validatedSelectedConsumer) {
      if (initialSelectedConsumer === null) {
        return;
      } else if (initialSelectedConsumer && consumers.includes(initialSelectedConsumer)) {
        onChange(initialSelectedConsumer);
        return;
      } else if (consumers.includes(_ruleDataUtils.STACK_ALERTS_FEATURE_ID)) {
        onChange(_ruleDataUtils.STACK_ALERTS_FEATURE_ID);
        return;
      }
      onChange(consumers[0]);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (consumers.length === 1) {
      onChange(consumers[0]);
    } else if (consumers.includes(_ruleDataUtils.AlertConsumers.OBSERVABILITY)) {
      onChange(_ruleDataUtils.AlertConsumers.OBSERVABILITY);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [consumers]);
  if (consumers.length <= 1 || consumers.includes(_ruleDataUtils.AlertConsumers.OBSERVABILITY)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: SELECT_LABEL,
    isInvalid: isInvalid,
    error: (_errors$consumer2 = errors === null || errors === void 0 ? void 0 : errors.consumer) !== null && _errors$consumer2 !== void 0 ? _errors$consumer2 : ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "ruleFormConsumerSelect",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.comboBox.ariaLabel', {
      defaultMessage: 'Select a scope'
    }),
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleFormConsumerSelectionModal.comboBox.placeholder', {
      defaultMessage: 'Select a scope'
    }),
    fullWidth: true,
    singleSelection: SINGLE_SELECTION,
    options: formattedSelectOptions,
    selectedOptions: selectedOptions,
    onChange: handleOnChange
  }));
};
exports.RuleFormConsumerSelection = RuleFormConsumerSelection;