"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlerts = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialAlertState = {
  loading: false,
  request: {
    featureIds: [],
    fields: [],
    query: {
      bool: {}
    },
    pagination: {
      pageIndex: 0,
      pageSize: 50
    },
    sort: _constants.DefaultSort
  },
  response: {
    alerts: [],
    oldAlertsData: [],
    ecsAlertsData: [],
    totalAlerts: -1,
    isInitializing: true,
    updatedAt: 0
  }
};
function alertReducer(state, action) {
  switch (action.type) {
    case 'loading':
      return {
        ...state,
        loading: action.loading
      };
    case 'response':
      return {
        ...state,
        loading: false,
        response: {
          isInitializing: false,
          alerts: action.alerts,
          totalAlerts: action.totalAlerts,
          oldAlertsData: action.oldAlertsData,
          ecsAlertsData: action.ecsAlertsData,
          updatedAt: Date.now()
        }
      };
    case 'resetPagination':
      return {
        ...state,
        request: {
          ...state.request,
          pagination: {
            ...state.request.pagination,
            pageIndex: 0
          }
        }
      };
    case 'request':
      return {
        ...state,
        request: action.request
      };
    default:
      throw new Error();
  }
}
const useFetchAlerts = ({
  featureIds,
  fields,
  query,
  pagination,
  onLoaded,
  onPageChange,
  runtimeMappings,
  skip,
  sort
}) => {
  const refetch = (0, _react.useRef)(_lodash.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [{
    loading,
    request: alertRequest,
    response: alertResponse
  }, dispatch] = (0, _react.useReducer)(alertReducer, initialAlertState);
  const prevAlertRequest = (0, _react.useRef)(null);
  const inspectQuery = (0, _react.useRef)({
    request: [],
    response: []
  });
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const getInspectQuery = (0, _react.useCallback)(() => inspectQuery.current, []);
  const refetchGrid = (0, _react.useCallback)(() => {
    var _prevAlertRequest$cur, _prevAlertRequest$cur2, _prevAlertRequest$cur3;
    if (((_prevAlertRequest$cur = (_prevAlertRequest$cur2 = prevAlertRequest.current) === null || _prevAlertRequest$cur2 === void 0 ? void 0 : (_prevAlertRequest$cur3 = _prevAlertRequest$cur2.pagination) === null || _prevAlertRequest$cur3 === void 0 ? void 0 : _prevAlertRequest$cur3.pageIndex) !== null && _prevAlertRequest$cur !== void 0 ? _prevAlertRequest$cur : 0) !== 0) {
      dispatch({
        type: 'resetPagination'
      });
    } else {
      refetch.current();
    }
  }, []);
  const fetchAlerts = (0, _react.useCallback)(request => {
    if (request == null || skip) {
      return;
    }
    const asyncSearch = async () => {
      prevAlertRequest.current = request;
      abortCtrl.current = new AbortController();
      dispatch({
        type: 'loading',
        loading: true
      });
      if (data && data.search) {
        searchSubscription$.current = data.search.search({
          ...request,
          featureIds,
          fields,
          query
        }, {
          strategy: 'privateRuleRegistryAlertsSearchStrategy',
          abortSignal: abortCtrl.current.signal
        }).subscribe({
          next: response => {
            if (!(0, _common.isRunningResponse)(response)) {
              var _response$inspect$dsl, _response$inspect, _ref;
              const {
                rawResponse
              } = response;
              inspectQuery.current = {
                request: (_response$inspect$dsl = response === null || response === void 0 ? void 0 : (_response$inspect = response.inspect) === null || _response$inspect === void 0 ? void 0 : _response$inspect.dsl) !== null && _response$inspect$dsl !== void 0 ? _response$inspect$dsl : [],
                response: (_ref = [JSON.stringify(rawResponse)]) !== null && _ref !== void 0 ? _ref : []
              };
              let totalAlerts = 0;
              if (rawResponse.hits.total && typeof rawResponse.hits.total === 'number') {
                totalAlerts = rawResponse.hits.total;
              } else if (rawResponse.hits.total && typeof rawResponse.hits.total === 'object') {
                var _rawResponse$hits$tot, _rawResponse$hits$tot2;
                totalAlerts = (_rawResponse$hits$tot = (_rawResponse$hits$tot2 = rawResponse.hits.total) === null || _rawResponse$hits$tot2 === void 0 ? void 0 : _rawResponse$hits$tot2.value) !== null && _rawResponse$hits$tot !== void 0 ? _rawResponse$hits$tot : 0;
              }
              const alerts = rawResponse.hits.hits.reduce((acc, hit) => {
                if (hit.fields) {
                  acc.push({
                    ...hit.fields,
                    _id: hit._id,
                    _index: hit._index
                  });
                }
                return acc;
              }, []);
              const {
                oldAlertsData,
                ecsAlertsData
              } = alerts.reduce((acc, alert) => {
                const itemOldData = Object.entries(alert).reduce((oldData, [key, value]) => {
                  oldData.push({
                    field: key,
                    value: value
                  });
                  return oldData;
                }, []);
                const ecsData = Object.entries(alert).reduce((ecs, [key, value]) => {
                  (0, _saferLodashSet.set)(ecs, key, value !== null && value !== void 0 ? value : []);
                  return ecs;
                }, {});
                acc.oldAlertsData.push(itemOldData);
                acc.ecsAlertsData.push(ecsData);
                return acc;
              }, {
                oldAlertsData: [],
                ecsAlertsData: []
              });
              dispatch({
                type: 'response',
                alerts,
                oldAlertsData,
                ecsAlertsData,
                totalAlerts
              });
              dispatch({
                type: 'loading',
                loading: false
              });
              onLoaded === null || onLoaded === void 0 ? void 0 : onLoaded();
              searchSubscription$.current.unsubscribe();
            }
          },
          error: msg => {
            dispatch({
              type: 'loading',
              loading: false
            });
            onLoaded === null || onLoaded === void 0 ? void 0 : onLoaded();
            data.search.showError(msg);
            searchSubscription$.current.unsubscribe();
          }
        });
      }
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [skip, data, featureIds, query, fields, onLoaded]);

  // FUTURE ENGINEER
  // This useEffect is only to fetch the alert when these props below changed
  // fields, pagination, sort, runtimeMappings
  (0, _react.useEffect)(() => {
    var _prevAlertRequest$cur4, _prevAlertRequest$cur5;
    if (featureIds.length === 0) {
      return;
    }
    const newAlertRequest = {
      featureIds,
      fields,
      pagination,
      query: (_prevAlertRequest$cur4 = (_prevAlertRequest$cur5 = prevAlertRequest.current) === null || _prevAlertRequest$cur5 === void 0 ? void 0 : _prevAlertRequest$cur5.query) !== null && _prevAlertRequest$cur4 !== void 0 ? _prevAlertRequest$cur4 : {},
      runtimeMappings,
      sort
    };
    if (newAlertRequest.fields.length > 0 && !(0, _fastDeepEqual.default)(newAlertRequest, prevAlertRequest.current)) {
      dispatch({
        type: 'request',
        request: newAlertRequest
      });
    }
  }, [featureIds, fields, pagination, sort, runtimeMappings]);

  // FUTURE ENGINEER
  // This useEffect is only to fetch the alert when query props changed
  // because we want to reset the pageIndex of pagination to 0
  (0, _react.useEffect)(() => {
    var _prevAlertRequest$cur6, _prevAlertRequest$cur7, _prevAlertRequest$cur8, _newAlertRequest$fiel;
    if (featureIds.length === 0 || !prevAlertRequest.current) {
      return;
    }
    const resetPagination = {
      pageIndex: 0,
      pageSize: (_prevAlertRequest$cur6 = (_prevAlertRequest$cur7 = prevAlertRequest.current) === null || _prevAlertRequest$cur7 === void 0 ? void 0 : (_prevAlertRequest$cur8 = _prevAlertRequest$cur7.pagination) === null || _prevAlertRequest$cur8 === void 0 ? void 0 : _prevAlertRequest$cur8.pageSize) !== null && _prevAlertRequest$cur6 !== void 0 ? _prevAlertRequest$cur6 : 50
    };
    const newAlertRequest = {
      ...prevAlertRequest.current,
      featureIds,
      pagination: resetPagination,
      query
    };
    if (((_newAlertRequest$fiel = newAlertRequest === null || newAlertRequest === void 0 ? void 0 : newAlertRequest.fields) !== null && _newAlertRequest$fiel !== void 0 ? _newAlertRequest$fiel : []).length > 0 && !(0, _fastDeepEqual.default)(newAlertRequest.query, prevAlertRequest.current.query)) {
      dispatch({
        type: 'request',
        request: newAlertRequest
      });
      onPageChange(resetPagination);
    }
  }, [featureIds, onPageChange, query]);
  (0, _react.useEffect)(() => {
    if (alertRequest.featureIds.length > 0 && !(0, _fastDeepEqual.default)(alertRequest, prevAlertRequest.current)) {
      fetchAlerts(alertRequest);
    }
  }, [alertRequest, fetchAlerts]);
  const alertResponseMemo = (0, _react.useMemo)(() => ({
    ...alertResponse,
    getInspectQuery,
    refetch: refetchGrid
  }), [alertResponse, getInspectQuery, refetchGrid]);
  return [loading, alertResponseMemo];
};
exports.useFetchAlerts = useFetchAlerts;